package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Feedback;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FeedbackCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class FeedbackRequest extends EntityRequest<Feedback> {

    public FeedbackRequest(ContextPath contextPath, Optional<Object> value) {
        super(Feedback.class, contextPath, value, false);
    }

    public ContactRequest contactId() {
        return new ContactRequest(contextPath.addSegment("ContactId"), Optional.empty());
    }

    public ContactRequest createdOnBehalfByContact() {
        return new ContactRequest(contextPath.addSegment("CreatedOnBehalfByContact"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest feedback_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("feedback_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest feedback_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("feedback_principalobjectattributeaccess"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SystemuserRequest modifiedOnBehalfBy() {
        return new SystemuserRequest(contextPath.addSegment("ModifiedOnBehalfBy"), Optional.empty());
    }

    public SystemuserRequest closedby() {
        return new SystemuserRequest(contextPath.addSegment("closedby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public ContactRequest createdByContact() {
        return new ContactRequest(contextPath.addSegment("CreatedByContact"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public FeedbackRequest feedbackId() {
        return new FeedbackRequest(contextPath.addSegment("FeedbackId"), Optional.empty());
    }

    public FeedbackRequest feedback_feedback(String feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("feedback_feedback").addKeys(new NameValue(feedbackid.toString())), Optional.empty());
    }

    public FeedbackCollectionRequest feedback_feedback() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("feedback_feedback"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorRequest feedback_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Feedback_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest feedback_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Feedback_SyncErrors"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgeArticleId() {
        return new KnowledgearticleRequest(contextPath.addSegment("KnowledgeArticleId"), Optional.empty());
    }

    public DuplicaterecordRequest feedback_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("feedback_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest feedback_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("feedback_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest feedback_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("feedback_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest feedback_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("feedback_DuplicateMatchingRecord"), Optional.empty());
    }

}
