package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.EntityMetadata;
import microsoft.dynamics.crm.entity.collection.request.AttributeMetadataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EntityKeyMetadataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ManyToManyRelationshipMetadataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OneToManyRelationshipMetadataCollectionRequest;

@JsonIgnoreType
public class EntityMetadataRequest extends EntityRequest<EntityMetadata> {

    public EntityMetadataRequest(ContextPath contextPath, Optional<Object> value) {
        super(EntityMetadata.class, contextPath, value, false);
    }

    public AttributeMetadataRequest attributes(String metadataId) {
        return new AttributeMetadataRequest(contextPath.addSegment("Attributes").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public AttributeMetadataCollectionRequest attributes() {
        return new AttributeMetadataCollectionRequest(
                        contextPath.addSegment("Attributes"), Optional.empty());
    }

    public ManyToManyRelationshipMetadataRequest manyToManyRelationships2(String metadataId) {
        return new ManyToManyRelationshipMetadataRequest(contextPath.addSegment("ManyToManyRelationships2").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public ManyToManyRelationshipMetadataCollectionRequest manyToManyRelationships2() {
        return new ManyToManyRelationshipMetadataCollectionRequest(
                        contextPath.addSegment("ManyToManyRelationships2"), Optional.empty());
    }

    public OneToManyRelationshipMetadataRequest manyToOneRelationships2(String metadataId) {
        return new OneToManyRelationshipMetadataRequest(contextPath.addSegment("ManyToOneRelationships2").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public OneToManyRelationshipMetadataCollectionRequest manyToOneRelationships2() {
        return new OneToManyRelationshipMetadataCollectionRequest(
                        contextPath.addSegment("ManyToOneRelationships2"), Optional.empty());
    }

    public OneToManyRelationshipMetadataRequest oneToManyRelationships2(String metadataId) {
        return new OneToManyRelationshipMetadataRequest(contextPath.addSegment("OneToManyRelationships2").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public OneToManyRelationshipMetadataCollectionRequest oneToManyRelationships2() {
        return new OneToManyRelationshipMetadataCollectionRequest(
                        contextPath.addSegment("OneToManyRelationships2"), Optional.empty());
    }

    public EntityKeyMetadataRequest keys(String metadataId) {
        return new EntityKeyMetadataRequest(contextPath.addSegment("Keys").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public EntityKeyMetadataCollectionRequest keys() {
        return new EntityKeyMetadataCollectionRequest(
                        contextPath.addSegment("Keys"), Optional.empty());
    }

}
