package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Asyncoperation;
import microsoft.dynamics.crm.entity.Duplicaterule;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicateruleconditionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class DuplicateruleRequest extends EntityRequest<Duplicaterule> {

    public DuplicateruleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Duplicaterule.class, contextPath, value, false);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SyncerrorRequest duplicateRule_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("DuplicateRule_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest duplicateRule_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("DuplicateRule_SyncErrors"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public DuplicateruleconditionRequest duplicateRule_DuplicateRuleConditions(String duplicateruleconditionid) {
        return new DuplicateruleconditionRequest(contextPath.addSegment("DuplicateRule_DuplicateRuleConditions").addKeys(new NameValue(duplicateruleconditionid.toString())), Optional.empty());
    }

    public DuplicateruleconditionCollectionRequest duplicateRule_DuplicateRuleConditions() {
        return new DuplicateruleconditionCollectionRequest(
                        contextPath.addSegment("DuplicateRule_DuplicateRuleConditions"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public AnnotationRequest duplicateRule_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("DuplicateRule_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest duplicateRule_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("DuplicateRule_Annotation"), Optional.empty());
    }

    public DuplicaterecordRequest duplicateRule_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("DuplicateRule_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest duplicateRule_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("DuplicateRule_DuplicateBaseRecord"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    @Action(name = "PublishDuplicateRule")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Asyncoperation> publishDuplicateRule() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Asyncoperation>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PublishDuplicateRule"), Asyncoperation.class, _parameters);
    }

}
