package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Customcontroldefaultconfig;

@JsonIgnoreType
public class CustomcontroldefaultconfigRequest extends EntityRequest<Customcontroldefaultconfig> {

    public CustomcontroldefaultconfigRequest(ContextPath contextPath, Optional<Object> value) {
        super(Customcontroldefaultconfig.class, contextPath, value, false);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Customcontroldefaultconfig> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Customcontroldefaultconfig>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Customcontroldefaultconfig.class, _parameters);
    }

}
