package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Category;
import microsoft.dynamics.crm.entity.collection.request.CategoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class CategoryRequest extends EntityRequest<Category> {

    public CategoryRequest(ContextPath contextPath, Optional<Object> value) {
        super(Category.class, contextPath, value, false);
    }

    public CategoryRequest parentcategoryid() {
        return new CategoryRequest(contextPath.addSegment("parentcategoryid"), Optional.empty());
    }

    public CategoryRequest category_parent_category(String categoryid) {
        return new CategoryRequest(contextPath.addSegment("category_parent_category").addKeys(new NameValue(categoryid.toString())), Optional.empty());
    }

    public CategoryCollectionRequest category_parent_category() {
        return new CategoryCollectionRequest(
                        contextPath.addSegment("category_parent_category"), Optional.empty());
    }

    public SyncerrorRequest category_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Category_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest category_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Category_SyncErrors"), Optional.empty());
    }

    public SystemuserRequest lk_category_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("lk_category_modifiedonbehalfby"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SystemuserRequest lk_category_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("lk_category_createdonbehalfby"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SystemuserRequest lk_category_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("lk_category_modifiedby"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticle_category(String knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticle_category").addKeys(new NameValue(knowledgearticleid.toString())), Optional.empty());
    }

    public KnowledgearticleCollectionRequest knowledgearticle_category() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("knowledgearticle_category"), Optional.empty());
    }

    public SystemuserRequest lk_category_createdby() {
        return new SystemuserRequest(contextPath.addSegment("lk_category_createdby"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

}
