package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Annotation;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class AnnotationRequest extends EntityRequest<Annotation> {

    public AnnotationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Annotation.class, contextPath, value, false);
    }

    public KnowledgearticleRequest objectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("objectid_knowledgearticle"), Optional.empty());
    }

    public KnowledgebaserecordRequest objectid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("objectid_knowledgebaserecord"), Optional.empty());
    }

    public AccountRequest objectid_account() {
        return new AccountRequest(contextPath.addSegment("objectid_account"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public KbarticleRequest objectid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("objectid_kbarticle"), Optional.empty());
    }

    public AppointmentRequest objectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("objectid_appointment"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public BulkdeletefailureRequest annotation_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Annotation_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest annotation_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Annotation_BulkDeleteFailures"), Optional.empty());
    }

    public SlaRequest objectid_sla() {
        return new SlaRequest(contextPath.addSegment("objectid_sla"), Optional.empty());
    }

    public CalendarRequest objectid_calendar() {
        return new CalendarRequest(contextPath.addSegment("objectid_calendar"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public FaxRequest objectid_fax() {
        return new FaxRequest(contextPath.addSegment("objectid_fax"), Optional.empty());
    }

    public ContactRequest objectid_contact() {
        return new ContactRequest(contextPath.addSegment("objectid_contact"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public LetterRequest objectid_letter() {
        return new LetterRequest(contextPath.addSegment("objectid_letter"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public GoalRequest objectid_goal() {
        return new GoalRequest(contextPath.addSegment("objectid_goal"), Optional.empty());
    }

    public TaskRequest objectid_task() {
        return new TaskRequest(contextPath.addSegment("objectid_task"), Optional.empty());
    }

    public EmailRequest objectid_email() {
        return new EmailRequest(contextPath.addSegment("objectid_email"), Optional.empty());
    }

    public WorkflowRequest objectid_workflow() {
        return new WorkflowRequest(contextPath.addSegment("objectid_workflow"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public AsyncoperationRequest annotation_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Annotation_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest annotation_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Annotation_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest annotation_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Annotation_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest annotation_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Annotation_ProcessSessions"), Optional.empty());
    }

    public MailboxRequest objectid_mailbox() {
        return new MailboxRequest(contextPath.addSegment("objectid_mailbox"), Optional.empty());
    }

    public SocialactivityRequest objectid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("objectid_socialactivity"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public DuplicateruleRequest objectid_duplicaterule() {
        return new DuplicateruleRequest(contextPath.addSegment("objectid_duplicaterule"), Optional.empty());
    }

    public SyncerrorRequest annotation_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Annotation_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest annotation_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Annotation_SyncErrors"), Optional.empty());
    }

    public PhonecallRequest objectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("objectid_phonecall"), Optional.empty());
    }

    public EmailserverprofileRequest objectid_emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("objectid_emailserverprofile"), Optional.empty());
    }

    public RecurringappointmentmasterRequest objectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("objectid_recurringappointmentmaster"), Optional.empty());
    }

    public Msdyn_aimodelRequest objectid_msdyn_aimodel() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("objectid_msdyn_aimodel"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest objectid_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("objectid_msdyn_aifptrainingdocument"), Optional.empty());
    }

    public Msdyn_aiodimageRequest objectid_msdyn_aiodimage() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("objectid_msdyn_aiodimage"), Optional.empty());
    }

}
