package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Similarityrule;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.SimilarityruleRequest;

public class SimilarityruleCollectionRequest extends CollectionPageEntityRequest<Similarityrule, SimilarityruleRequest>{

    protected ContextPath contextPath;

    public SimilarityruleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Similarityrule.class, cp -> new SimilarityruleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationRequest similarityrule_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("similarityrule_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest similarityrule_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("similarityrule_AsyncOperations"), Optional.empty());
    }

}
