package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Serviceendpoint;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;
import microsoft.dynamics.crm.entity.request.ServiceendpointRequest;

public class ServiceendpointCollectionRequest extends CollectionPageEntityRequest<Serviceendpoint, ServiceendpointRequest>{

    protected ContextPath contextPath;

    public ServiceendpointCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Serviceendpoint.class, cp -> new ServiceendpointRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SdkmessageprocessingstepRequest serviceendpoint_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("serviceendpoint_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest serviceendpoint_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(contextPath.addSegment("serviceendpoint_sdkmessageprocessingstep"), Optional.empty());
    }

}
