package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Plugintype;
import microsoft.dynamics.crm.entity.request.PlugintypeRequest;
import microsoft.dynamics.crm.entity.request.PlugintypestatisticRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;

public class PlugintypeCollectionRequest extends CollectionPageEntityRequest<Plugintype, PlugintypeRequest>{

    protected ContextPath contextPath;

    public PlugintypeCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Plugintype.class, cp -> new PlugintypeRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SdkmessageprocessingstepRequest plugintypeid_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("plugintypeid_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest plugintypeid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(contextPath.addSegment("plugintypeid_sdkmessageprocessingstep"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest plugintype_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("plugintype_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest plugintype_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(contextPath.addSegment("plugintype_sdkmessageprocessingstep"), Optional.empty());
    }

    public PlugintypestatisticRequest plugintype_plugintypestatistic(String plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("plugintype_plugintypestatistic").addKeys(new NameValue(plugintypestatisticid.toString())), Optional.empty());
    }

    public PlugintypestatisticCollectionRequest plugintype_plugintypestatistic() {
        return new PlugintypestatisticCollectionRequest(contextPath.addSegment("plugintype_plugintypestatistic"), Optional.empty());
    }

}
