package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Mailbox;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TracelogRequest;

public class MailboxCollectionRequest extends CollectionPageEntityRequest<Mailbox, MailboxRequest>{

    protected ContextPath contextPath;

    public MailboxCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Mailbox.class, cp -> new MailboxRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SystemuserRequest systemuser_defaultmailbox_mailbox(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("systemuser_defaultmailbox_mailbox").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest systemuser_defaultmailbox_mailbox() {
        return new SystemuserCollectionRequest(contextPath.addSegment("systemuser_defaultmailbox_mailbox"), Optional.empty());
    }

    public QueueRequest queue_defaultmailbox_mailbox(String queueid) {
        return new QueueRequest(contextPath.addSegment("queue_defaultmailbox_mailbox").addKeys(new NameValue(queueid.toString())), Optional.empty());
    }

    public QueueCollectionRequest queue_defaultmailbox_mailbox() {
        return new QueueCollectionRequest(contextPath.addSegment("queue_defaultmailbox_mailbox"), Optional.empty());
    }

    public TracelogRequest tracelog_Mailbox(String tracelogid) {
        return new TracelogRequest(contextPath.addSegment("tracelog_Mailbox").addKeys(new NameValue(tracelogid.toString())), Optional.empty());
    }

    public TracelogCollectionRequest tracelog_Mailbox() {
        return new TracelogCollectionRequest(contextPath.addSegment("tracelog_Mailbox"), Optional.empty());
    }

    public ActivitypointerRequest activitypointer_sendermailboxid_mailbox(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("activitypointer_sendermailboxid_mailbox").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ActivitypointerCollectionRequest activitypointer_sendermailboxid_mailbox() {
        return new ActivitypointerCollectionRequest(contextPath.addSegment("activitypointer_sendermailboxid_mailbox"), Optional.empty());
    }

    public AsyncoperationRequest mailbox_asyncoperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("mailbox_asyncoperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest mailbox_asyncoperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("mailbox_asyncoperations"), Optional.empty());
    }

    public EmailRequest email_sendermailboxid_mailbox(String activityid) {
        return new EmailRequest(contextPath.addSegment("email_sendermailboxid_mailbox").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public EmailCollectionRequest email_sendermailboxid_mailbox() {
        return new EmailCollectionRequest(contextPath.addSegment("email_sendermailboxid_mailbox"), Optional.empty());
    }

    public SyncerrorRequest mailbox_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Mailbox_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest mailbox_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Mailbox_SyncErrors"), Optional.empty());
    }

    public AnnotationRequest mailbox_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Mailbox_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest mailbox_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("Mailbox_Annotation"), Optional.empty());
    }

    public MailboxtrackingfolderRequest mailbox_MailboxTrackingFolder(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("Mailbox_MailboxTrackingFolder").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest mailbox_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("Mailbox_MailboxTrackingFolder"), Optional.empty());
    }

    public ProcesssessionRequest mailbox_processsessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("mailbox_processsessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest mailbox_processsessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("mailbox_processsessions"), Optional.empty());
    }

}
