package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Interactionforemail;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.InteractionforemailRequest;

public class InteractionforemailCollectionRequest extends CollectionPageEntityRequest<Interactionforemail, InteractionforemailRequest>{

    protected ContextPath contextPath;

    public InteractionforemailCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Interactionforemail.class, cp -> new InteractionforemailRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ActivitypointerRequest new_interactionforemail_ActivityPointers(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("new_interactionforemail_ActivityPointers").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ActivitypointerCollectionRequest new_interactionforemail_ActivityPointers() {
        return new ActivitypointerCollectionRequest(contextPath.addSegment("new_interactionforemail_ActivityPointers"), Optional.empty());
    }

    public AsyncoperationRequest new_interactionforemail_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("new_interactionforemail_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest new_interactionforemail_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("new_interactionforemail_AsyncOperations"), Optional.empty());
    }

}
