package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Ggw_event;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.Ggw_eventRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Ggw_eventCollectionRequest extends CollectionPageEntityRequest<Ggw_event, Ggw_eventRequest>{

    protected ContextPath contextPath;

    public Ggw_eventCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Ggw_event.class, cp -> new Ggw_eventRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest ggw_event_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ggw_event_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest ggw_event_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ggw_event_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest ggw_event_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("ggw_event_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest ggw_event_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("ggw_event_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest ggw_event_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("ggw_event_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest ggw_event_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("ggw_event_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest ggw_event_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ggw_event_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest ggw_event_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("ggw_event_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest ggw_event_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("ggw_event_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest ggw_event_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("ggw_event_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest ggw_event_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("ggw_event_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest ggw_event_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("ggw_event_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest ggw_event_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ggw_event_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest ggw_event_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("ggw_event_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest ggw_event_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("ggw_event_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest ggw_event_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("ggw_event_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Ggw_teamRequest ggw_ggw_event_ggw_team(String ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("ggw_ggw_event_ggw_team").addKeys(new NameValue(ggw_teamid.toString())), Optional.empty());
    }

    public Ggw_teamCollectionRequest ggw_ggw_event_ggw_team() {
        return new Ggw_teamCollectionRequest(contextPath.addSegment("ggw_ggw_event_ggw_team"), Optional.empty());
    }

}
