package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Fileattachment;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class FileattachmentCollectionRequest extends CollectionPageEntityRequest<Fileattachment, FileattachmentRequest>{

    protected ContextPath contextPath;

    public FileattachmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Fileattachment.class, cp -> new FileattachmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest fileAttachment_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("FileAttachment_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest fileAttachment_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("FileAttachment_SyncErrors"), Optional.empty());
    }

    public SolutionRequest solution_fileid(String solutionid) {
        return new SolutionRequest(contextPath.addSegment("solution_fileid").addKeys(new NameValue(solutionid.toString())), Optional.empty());
    }

    public SolutionCollectionRequest solution_fileid() {
        return new SolutionCollectionRequest(contextPath.addSegment("solution_fileid"), Optional.empty());
    }

    public AsyncoperationRequest fileAttachment_AsyncOperation_DataBlobId(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("FileAttachment_AsyncOperation_DataBlobId").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest fileAttachment_AsyncOperation_DataBlobId() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("FileAttachment_AsyncOperation_DataBlobId"), Optional.empty());
    }

}
