package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AccountCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActioncarduserstateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnualfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BusinessunitCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CategoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ContactCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomeraddressCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExpiredprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FeedbackCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FixedmonthlyfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.InteractionforemailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleviewsCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgebaserecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailmergetemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MonthlyfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NewprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OfficegraphdocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OrganizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PositionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QuarterlyfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecommendeddocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ReportcategoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SemiannualfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointsiteCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SimilarityruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TerritoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ThemeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TranslationprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UsermappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UsersettingsCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdonbehalfby_value", 
    "isocurrencycode", 
    "_createdby_value", 
    "statuscode", 
    "_organizationid_value", 
    "currencyname", 
    "overriddencreatedon", 
    "_modifiedonbehalfby_value", 
    "entityimage", 
    "entityimageid", 
    "exchangerate", 
    "currencysymbol", 
    "entityimage_url", 
    "createdon", 
    "currencyprecision", 
    "modifiedon", 
    "entityimage_timestamp", 
    "transactioncurrencyid", 
    "statecode", 
    "importsequencenumber", 
    "versionnumber", 
    "_modifiedby_value"})
@JsonInclude(Include.NON_NULL)
public class Transactioncurrency extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.transactioncurrency";
    }

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("isocurrencycode")
    protected String isocurrencycode;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("currencyname")
    protected String currencyname;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("entityimage")
    protected byte[] entityimage;

    @JsonProperty("entityimageid")
    protected String entityimageid;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("currencysymbol")
    protected String currencysymbol;

    @JsonProperty("entityimage_url")
    protected String entityimage_url;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("currencyprecision")
    protected Integer currencyprecision;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("entityimage_timestamp")
    protected Long entityimage_timestamp;

    @JsonProperty("transactioncurrencyid")
    protected String transactioncurrencyid;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    protected Transactioncurrency() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTransactioncurrency() {
        return new Builder();
    }

    public static final class Builder {
        private String _createdonbehalfby_value;
        private String isocurrencycode;
        private String _createdby_value;
        private Integer statuscode;
        private String _organizationid_value;
        private String currencyname;
        private OffsetDateTime overriddencreatedon;
        private String _modifiedonbehalfby_value;
        private byte[] entityimage;
        private String entityimageid;
        private BigDecimal exchangerate;
        private String currencysymbol;
        private String entityimage_url;
        private OffsetDateTime createdon;
        private Integer currencyprecision;
        private OffsetDateTime modifiedon;
        private Long entityimage_timestamp;
        private String transactioncurrencyid;
        private Integer statecode;
        private Integer importsequencenumber;
        private Long versionnumber;
        private String _modifiedby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder isocurrencycode(String isocurrencycode) {
            this.isocurrencycode = isocurrencycode;
            this.changedFields = changedFields.add("isocurrencycode");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder currencyname(String currencyname) {
            this.currencyname = currencyname;
            this.changedFields = changedFields.add("currencyname");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder entityimage(byte[] entityimage) {
            this.entityimage = entityimage;
            this.changedFields = changedFields.add("entityimage");
            return this;
        }

        public Builder entityimageid(String entityimageid) {
            this.entityimageid = entityimageid;
            this.changedFields = changedFields.add("entityimageid");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder currencysymbol(String currencysymbol) {
            this.currencysymbol = currencysymbol;
            this.changedFields = changedFields.add("currencysymbol");
            return this;
        }

        public Builder entityimage_url(String entityimage_url) {
            this.entityimage_url = entityimage_url;
            this.changedFields = changedFields.add("entityimage_url");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder currencyprecision(Integer currencyprecision) {
            this.currencyprecision = currencyprecision;
            this.changedFields = changedFields.add("currencyprecision");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder entityimage_timestamp(Long entityimage_timestamp) {
            this.entityimage_timestamp = entityimage_timestamp;
            this.changedFields = changedFields.add("entityimage_timestamp");
            return this;
        }

        public Builder transactioncurrencyid(String transactioncurrencyid) {
            this.transactioncurrencyid = transactioncurrencyid;
            this.changedFields = changedFields.add("transactioncurrencyid");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Transactioncurrency build() {
            Transactioncurrency _x = new Transactioncurrency();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.transactioncurrency";
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.isocurrencycode = isocurrencycode;
            _x._createdby_value = _createdby_value;
            _x.statuscode = statuscode;
            _x._organizationid_value = _organizationid_value;
            _x.currencyname = currencyname;
            _x.overriddencreatedon = overriddencreatedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.entityimage = entityimage;
            _x.entityimageid = entityimageid;
            _x.exchangerate = exchangerate;
            _x.currencysymbol = currencysymbol;
            _x.entityimage_url = entityimage_url;
            _x.createdon = createdon;
            _x.currencyprecision = currencyprecision;
            _x.modifiedon = modifiedon;
            _x.entityimage_timestamp = entityimage_timestamp;
            _x.transactioncurrencyid = transactioncurrencyid;
            _x.statecode = statecode;
            _x.importsequencenumber = importsequencenumber;
            _x.versionnumber = versionnumber;
            _x._modifiedby_value = _modifiedby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && transactioncurrencyid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(transactioncurrencyid.toString()));
        }
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Transactioncurrency with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="isocurrencycode")
    @JsonIgnore
    public Optional<String> getIsocurrencycode() {
        return Optional.ofNullable(isocurrencycode);
    }

    public Transactioncurrency withIsocurrencycode(String isocurrencycode) {
        Checks.checkIsAscii(isocurrencycode);
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("isocurrencycode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.isocurrencycode = isocurrencycode;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Transactioncurrency with_createdby_value(String _createdby_value) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Transactioncurrency withStatuscode(Integer statuscode) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Transactioncurrency with_organizationid_value(String _organizationid_value) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="currencyname")
    @JsonIgnore
    public Optional<String> getCurrencyname() {
        return Optional.ofNullable(currencyname);
    }

    public Transactioncurrency withCurrencyname(String currencyname) {
        Checks.checkIsAscii(currencyname);
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("currencyname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.currencyname = currencyname;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Transactioncurrency withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Transactioncurrency with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="entityimage")
    @JsonIgnore
    public Optional<byte[]> getEntityimage() {
        return Optional.ofNullable(entityimage);
    }

    public Transactioncurrency withEntityimage(byte[] entityimage) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("entityimage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.entityimage = entityimage;
        return _x;
    }

    @Property(name="entityimageid")
    @JsonIgnore
    public Optional<String> getEntityimageid() {
        return Optional.ofNullable(entityimageid);
    }

    public Transactioncurrency withEntityimageid(String entityimageid) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("entityimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.entityimageid = entityimageid;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Transactioncurrency withExchangerate(BigDecimal exchangerate) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="currencysymbol")
    @JsonIgnore
    public Optional<String> getCurrencysymbol() {
        return Optional.ofNullable(currencysymbol);
    }

    public Transactioncurrency withCurrencysymbol(String currencysymbol) {
        Checks.checkIsAscii(currencysymbol);
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("currencysymbol");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.currencysymbol = currencysymbol;
        return _x;
    }

    @Property(name="entityimage_url")
    @JsonIgnore
    public Optional<String> getEntityimage_url() {
        return Optional.ofNullable(entityimage_url);
    }

    public Transactioncurrency withEntityimage_url(String entityimage_url) {
        Checks.checkIsAscii(entityimage_url);
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("entityimage_url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.entityimage_url = entityimage_url;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Transactioncurrency withCreatedon(OffsetDateTime createdon) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="currencyprecision")
    @JsonIgnore
    public Optional<Integer> getCurrencyprecision() {
        return Optional.ofNullable(currencyprecision);
    }

    public Transactioncurrency withCurrencyprecision(Integer currencyprecision) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("currencyprecision");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.currencyprecision = currencyprecision;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Transactioncurrency withModifiedon(OffsetDateTime modifiedon) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="entityimage_timestamp")
    @JsonIgnore
    public Optional<Long> getEntityimage_timestamp() {
        return Optional.ofNullable(entityimage_timestamp);
    }

    public Transactioncurrency withEntityimage_timestamp(Long entityimage_timestamp) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("entityimage_timestamp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.entityimage_timestamp = entityimage_timestamp;
        return _x;
    }

    @Property(name="transactioncurrencyid")
    @JsonIgnore
    public Optional<String> getTransactioncurrencyid() {
        return Optional.ofNullable(transactioncurrencyid);
    }

    public Transactioncurrency withTransactioncurrencyid(String transactioncurrencyid) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("transactioncurrencyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.transactioncurrencyid = transactioncurrencyid;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Transactioncurrency withStatecode(Integer statecode) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Transactioncurrency withImportsequencenumber(Integer importsequencenumber) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Transactioncurrency withVersionnumber(Long versionnumber) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Transactioncurrency with_modifiedby_value(String _modifiedby_value) {
        Transactioncurrency _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transactioncurrency");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    public Transactioncurrency withUnmappedField(String name, String value) {
        Transactioncurrency _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="TransactionCurrency_Goal")
    @JsonIgnore
    public GoalCollectionRequest getTransactionCurrency_Goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Goal"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Goal"));
    }

    @NavigationProperty(name="TransactionCurrency_Email")
    @JsonIgnore
    public EmailCollectionRequest getTransactionCurrency_Email() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Email"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Email"));
    }

    @NavigationProperty(name="TransactionCurrency_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getTransactionCurrency_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="TransactionCurrency_BusinessUnit")
    @JsonIgnore
    public BusinessunitCollectionRequest getTransactionCurrency_BusinessUnit() {
        return new BusinessunitCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_BusinessUnit"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_BusinessUnit"));
    }

    @NavigationProperty(name="TransactionCurrency_Connection")
    @JsonIgnore
    public ConnectionCollectionRequest getTransactionCurrency_Connection() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Connection"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Connection"));
    }

    @NavigationProperty(name="TransactionCurrency_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getTransactionCurrency_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="transactioncurrency_annualfiscalcalendar")
    @JsonIgnore
    public AnnualfiscalcalendarCollectionRequest getTransactioncurrency_annualfiscalcalendar() {
        return new AnnualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("transactioncurrency_annualfiscalcalendar"), RequestHelper.getValue(unmappedFields, "transactioncurrency_annualfiscalcalendar"));
    }

    @NavigationProperty(name="TransactionCurrency_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getTransactionCurrency_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_ProcessSessions"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_ProcessSessions"));
    }

    @NavigationProperty(name="TransactionCurrency_PhoneCall")
    @JsonIgnore
    public PhonecallCollectionRequest getTransactionCurrency_PhoneCall() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_PhoneCall"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_PhoneCall"));
    }

    @NavigationProperty(name="TransactionCurrency_recommendeddocument")
    @JsonIgnore
    public RecommendeddocumentCollectionRequest getTransactionCurrency_recommendeddocument() {
        return new RecommendeddocumentCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_recommendeddocument"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_recommendeddocument"));
    }

    @NavigationProperty(name="transactioncurrency_socialactivity")
    @JsonIgnore
    public SocialactivityCollectionRequest getTransactioncurrency_socialactivity() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("transactioncurrency_socialactivity"), RequestHelper.getValue(unmappedFields, "transactioncurrency_socialactivity"));
    }

    @NavigationProperty(name="TransactionCurrency_MailMergeTemplate")
    @JsonIgnore
    public MailmergetemplateCollectionRequest getTransactionCurrency_MailMergeTemplate() {
        return new MailmergetemplateCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_MailMergeTemplate"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_MailMergeTemplate"));
    }

    @NavigationProperty(name="TransactionCurrency_ActivityPointer")
    @JsonIgnore
    public ActivitypointerCollectionRequest getTransactionCurrency_ActivityPointer() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_ActivityPointer"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_ActivityPointer"));
    }

    @NavigationProperty(name="TransactionCurrency_SystemUser")
    @JsonIgnore
    public SystemuserCollectionRequest getTransactionCurrency_SystemUser() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_SystemUser"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_SystemUser"));
    }

    @NavigationProperty(name="TransactionCurrency_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getTransactionCurrency_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_AsyncOperations"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_AsyncOperations"));
    }

    @NavigationProperty(name="transactioncurrency_monthlyfiscalcalendar")
    @JsonIgnore
    public MonthlyfiscalcalendarCollectionRequest getTransactioncurrency_monthlyfiscalcalendar() {
        return new MonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("transactioncurrency_monthlyfiscalcalendar"), RequestHelper.getValue(unmappedFields, "transactioncurrency_monthlyfiscalcalendar"));
    }

    @NavigationProperty(name="transactioncurrency_fixedmonthlyfiscalcalendar")
    @JsonIgnore
    public FixedmonthlyfiscalcalendarCollectionRequest getTransactioncurrency_fixedmonthlyfiscalcalendar() {
        return new FixedmonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("transactioncurrency_fixedmonthlyfiscalcalendar"), RequestHelper.getValue(unmappedFields, "transactioncurrency_fixedmonthlyfiscalcalendar"));
    }

    @NavigationProperty(name="transactioncurrency_account")
    @JsonIgnore
    public AccountCollectionRequest getTransactioncurrency_account() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("transactioncurrency_account"), RequestHelper.getValue(unmappedFields, "transactioncurrency_account"));
    }

    @NavigationProperty(name="transactioncurrency_quarterlyfiscalcalendar")
    @JsonIgnore
    public QuarterlyfiscalcalendarCollectionRequest getTransactioncurrency_quarterlyfiscalcalendar() {
        return new QuarterlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("transactioncurrency_quarterlyfiscalcalendar"), RequestHelper.getValue(unmappedFields, "transactioncurrency_quarterlyfiscalcalendar"));
    }

    @NavigationProperty(name="TransactionCurrency_KnowledgeBaseRecord")
    @JsonIgnore
    public KnowledgebaserecordCollectionRequest getTransactionCurrency_KnowledgeBaseRecord() {
        return new KnowledgebaserecordCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_KnowledgeBaseRecord"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_KnowledgeBaseRecord"));
    }

    @NavigationProperty(name="transactioncurrency_knowledgearticleviews")
    @JsonIgnore
    public KnowledgearticleviewsCollectionRequest getTransactioncurrency_knowledgearticleviews() {
        return new KnowledgearticleviewsCollectionRequest(
                        contextPath.addSegment("transactioncurrency_knowledgearticleviews"), RequestHelper.getValue(unmappedFields, "transactioncurrency_knowledgearticleviews"));
    }

    @NavigationProperty(name="TransactionCurrency_CustomerAddress")
    @JsonIgnore
    public CustomeraddressCollectionRequest getTransactionCurrency_CustomerAddress() {
        return new CustomeraddressCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_CustomerAddress"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_CustomerAddress"));
    }

    @NavigationProperty(name="TransactionCurrency_Fax")
    @JsonIgnore
    public FaxCollectionRequest getTransactionCurrency_Fax() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Fax"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Fax"));
    }

    @NavigationProperty(name="transactioncurrency_position")
    @JsonIgnore
    public PositionCollectionRequest getTransactioncurrency_position() {
        return new PositionCollectionRequest(
                        contextPath.addSegment("transactioncurrency_position"), RequestHelper.getValue(unmappedFields, "transactioncurrency_position"));
    }

    @NavigationProperty(name="transactioncurrency_expiredprocess")
    @JsonIgnore
    public ExpiredprocessCollectionRequest getTransactioncurrency_expiredprocess() {
        return new ExpiredprocessCollectionRequest(
                        contextPath.addSegment("transactioncurrency_expiredprocess"), RequestHelper.getValue(unmappedFields, "transactioncurrency_expiredprocess"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="transactioncurrency_actioncard")
    @JsonIgnore
    public ActioncardCollectionRequest getTransactioncurrency_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("transactioncurrency_actioncard"), RequestHelper.getValue(unmappedFields, "transactioncurrency_actioncard"));
    }

    @NavigationProperty(name="TransactionCurrency_Task")
    @JsonIgnore
    public TaskCollectionRequest getTransactionCurrency_Task() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Task"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Task"));
    }

    @NavigationProperty(name="basecurrency_organization")
    @JsonIgnore
    public OrganizationCollectionRequest getBasecurrency_organization() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("basecurrency_organization"), RequestHelper.getValue(unmappedFields, "basecurrency_organization"));
    }

    @NavigationProperty(name="transactioncurrency_feedback")
    @JsonIgnore
    public FeedbackCollectionRequest getTransactioncurrency_feedback() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("transactioncurrency_feedback"), RequestHelper.getValue(unmappedFields, "transactioncurrency_feedback"));
    }

    @NavigationProperty(name="TransactionCurrency_SimilarityRule")
    @JsonIgnore
    public SimilarityruleCollectionRequest getTransactionCurrency_SimilarityRule() {
        return new SimilarityruleCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_SimilarityRule"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_SimilarityRule"));
    }

    @NavigationProperty(name="transactioncurrency_category")
    @JsonIgnore
    public CategoryCollectionRequest getTransactioncurrency_category() {
        return new CategoryCollectionRequest(
                        contextPath.addSegment("transactioncurrency_category"), RequestHelper.getValue(unmappedFields, "transactioncurrency_category"));
    }

    @NavigationProperty(name="TransactionCurrency_Team")
    @JsonIgnore
    public TeamCollectionRequest getTransactionCurrency_Team() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Team"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Team"));
    }

    @NavigationProperty(name="TransactionCurrency_SLA")
    @JsonIgnore
    public SlaCollectionRequest getTransactionCurrency_SLA() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_SLA"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_SLA"));
    }

    @NavigationProperty(name="TransactionCurrency_RecurringAppointmentMaster")
    @JsonIgnore
    public RecurringappointmentmasterCollectionRequest getTransactionCurrency_RecurringAppointmentMaster() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_RecurringAppointmentMaster"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_RecurringAppointmentMaster"));
    }

    @NavigationProperty(name="transactioncurrency_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleCollectionRequest getTransactioncurrency_knowledgearticle() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("transactioncurrency_knowledgearticle"), RequestHelper.getValue(unmappedFields, "transactioncurrency_knowledgearticle"));
    }

    @NavigationProperty(name="TransactionCurrency_Theme")
    @JsonIgnore
    public ThemeCollectionRequest getTransactionCurrency_Theme() {
        return new ThemeCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Theme"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Theme"));
    }

    @NavigationProperty(name="TransactionCurrency_Letter")
    @JsonIgnore
    public LetterCollectionRequest getTransactionCurrency_Letter() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Letter"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Letter"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="TransactionCurrency_UserMapping")
    @JsonIgnore
    public UsermappingCollectionRequest getTransactionCurrency_UserMapping() {
        return new UsermappingCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_UserMapping"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_UserMapping"));
    }

    @NavigationProperty(name="TransactionCurrency_Queue")
    @JsonIgnore
    public QueueCollectionRequest getTransactionCurrency_Queue() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Queue"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Queue"));
    }

    @NavigationProperty(name="transactioncurrency_SocialProfile")
    @JsonIgnore
    public SocialprofileCollectionRequest getTransactioncurrency_SocialProfile() {
        return new SocialprofileCollectionRequest(
                        contextPath.addSegment("transactioncurrency_SocialProfile"), RequestHelper.getValue(unmappedFields, "transactioncurrency_SocialProfile"));
    }

    @NavigationProperty(name="transactioncurrency_contact")
    @JsonIgnore
    public ContactCollectionRequest getTransactioncurrency_contact() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("transactioncurrency_contact"), RequestHelper.getValue(unmappedFields, "transactioncurrency_contact"));
    }

    @NavigationProperty(name="TransactionCurrency_ActionCardUserState")
    @JsonIgnore
    public ActioncarduserstateCollectionRequest getTransactionCurrency_ActionCardUserState() {
        return new ActioncarduserstateCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_ActionCardUserState"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_ActionCardUserState"));
    }

    @NavigationProperty(name="TransactionCurrency_Appointment")
    @JsonIgnore
    public AppointmentCollectionRequest getTransactionCurrency_Appointment() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Appointment"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Appointment"));
    }

    @NavigationProperty(name="TransactionCurrency_SharePointSite")
    @JsonIgnore
    public SharepointsiteCollectionRequest getTransactionCurrency_SharePointSite() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_SharePointSite"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_SharePointSite"));
    }

    @NavigationProperty(name="TransactionCurrency_SharePointDocumentLocation")
    @JsonIgnore
    public SharepointdocumentlocationCollectionRequest getTransactionCurrency_SharePointDocumentLocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_SharePointDocumentLocation"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_SharePointDocumentLocation"));
    }

    @NavigationProperty(name="TransactionCurrency_SLAItem")
    @JsonIgnore
    public SlaitemCollectionRequest getTransactionCurrency_SLAItem() {
        return new SlaitemCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_SLAItem"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_SLAItem"));
    }

    @NavigationProperty(name="transactioncurrency_newprocess")
    @JsonIgnore
    public NewprocessCollectionRequest getTransactioncurrency_newprocess() {
        return new NewprocessCollectionRequest(
                        contextPath.addSegment("transactioncurrency_newprocess"), RequestHelper.getValue(unmappedFields, "transactioncurrency_newprocess"));
    }

    @NavigationProperty(name="TransactionCurrency_KbArticle")
    @JsonIgnore
    public KbarticleCollectionRequest getTransactionCurrency_KbArticle() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_KbArticle"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_KbArticle"));
    }

    @NavigationProperty(name="TransactionCurrency_QueueItem")
    @JsonIgnore
    public QueueitemCollectionRequest getTransactionCurrency_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_QueueItem"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_QueueItem"));
    }

    @NavigationProperty(name="TransactionCurrency_ReportCategory")
    @JsonIgnore
    public ReportcategoryCollectionRequest getTransactionCurrency_ReportCategory() {
        return new ReportcategoryCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_ReportCategory"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_ReportCategory"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="transactioncurrency_semiannualfiscalcalendar")
    @JsonIgnore
    public SemiannualfiscalcalendarCollectionRequest getTransactioncurrency_semiannualfiscalcalendar() {
        return new SemiannualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("transactioncurrency_semiannualfiscalcalendar"), RequestHelper.getValue(unmappedFields, "transactioncurrency_semiannualfiscalcalendar"));
    }

    @NavigationProperty(name="transactioncurrency_usersettings")
    @JsonIgnore
    public UsersettingsCollectionRequest getTransactioncurrency_usersettings() {
        return new UsersettingsCollectionRequest(
                        contextPath.addSegment("transactioncurrency_usersettings"), RequestHelper.getValue(unmappedFields, "transactioncurrency_usersettings"));
    }

    @NavigationProperty(name="transactioncurrency_translationprocess")
    @JsonIgnore
    public TranslationprocessCollectionRequest getTransactioncurrency_translationprocess() {
        return new TranslationprocessCollectionRequest(
                        contextPath.addSegment("transactioncurrency_translationprocess"), RequestHelper.getValue(unmappedFields, "transactioncurrency_translationprocess"));
    }

    @NavigationProperty(name="TransactionCurrency_slakpiinstance")
    @JsonIgnore
    public SlakpiinstanceCollectionRequest getTransactionCurrency_slakpiinstance() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_slakpiinstance"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_slakpiinstance"));
    }

    @NavigationProperty(name="TransactionCurrency_officegraphdocument")
    @JsonIgnore
    public OfficegraphdocumentCollectionRequest getTransactionCurrency_officegraphdocument() {
        return new OfficegraphdocumentCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_officegraphdocument"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_officegraphdocument"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="TransactionCurrency_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getTransactionCurrency_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_SyncErrors"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_SyncErrors"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="TransactionCurrency_InteractionForEmail")
    @JsonIgnore
    public InteractionforemailCollectionRequest getTransactionCurrency_InteractionForEmail() {
        return new InteractionforemailCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_InteractionForEmail"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_InteractionForEmail"));
    }

    @NavigationProperty(name="TransactionCurrency_Territory")
    @JsonIgnore
    public TerritoryCollectionRequest getTransactionCurrency_Territory() {
        return new TerritoryCollectionRequest(
                        contextPath.addSegment("TransactionCurrency_Territory"), RequestHelper.getValue(unmappedFields, "TransactionCurrency_Territory"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Transactioncurrency patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Transactioncurrency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Transactioncurrency put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Transactioncurrency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Transactioncurrency _copy() {
        Transactioncurrency _x = new Transactioncurrency();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.isocurrencycode = isocurrencycode;
        _x._createdby_value = _createdby_value;
        _x.statuscode = statuscode;
        _x._organizationid_value = _organizationid_value;
        _x.currencyname = currencyname;
        _x.overriddencreatedon = overriddencreatedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.entityimage = entityimage;
        _x.entityimageid = entityimageid;
        _x.exchangerate = exchangerate;
        _x.currencysymbol = currencysymbol;
        _x.entityimage_url = entityimage_url;
        _x.createdon = createdon;
        _x.currencyprecision = currencyprecision;
        _x.modifiedon = modifiedon;
        _x.entityimage_timestamp = entityimage_timestamp;
        _x.transactioncurrencyid = transactioncurrencyid;
        _x.statecode = statecode;
        _x.importsequencenumber = importsequencenumber;
        _x.versionnumber = versionnumber;
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Transactioncurrency[");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("isocurrencycode=");
        b.append(this.isocurrencycode);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("currencyname=");
        b.append(this.currencyname);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("entityimage=");
        b.append(this.entityimage);
        b.append(", ");
        b.append("entityimageid=");
        b.append(this.entityimageid);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("currencysymbol=");
        b.append(this.currencysymbol);
        b.append(", ");
        b.append("entityimage_url=");
        b.append(this.entityimage_url);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("currencyprecision=");
        b.append(this.currencyprecision);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("entityimage_timestamp=");
        b.append(this.entityimage_timestamp);
        b.append(", ");
        b.append("transactioncurrencyid=");
        b.append(this.transactioncurrencyid);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
