package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.PrincipalRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "objecttypecode", 
    "principalid", 
    "principalentitymapid", 
    "versionnumber"})
@JsonInclude(Include.NON_NULL)
public class Principalentitymap extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.principalentitymap";
    }

    @JsonProperty("objecttypecode")
    protected String objecttypecode;

    @JsonProperty("principalid")
    protected String principalid;

    @JsonProperty("principalentitymapid")
    protected String principalentitymapid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    protected Principalentitymap() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrincipalentitymap() {
        return new Builder();
    }

    public static final class Builder {
        private String objecttypecode;
        private String principalid;
        private String principalentitymapid;
        private Long versionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder objecttypecode(String objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder principalid(String principalid) {
            this.principalid = principalid;
            this.changedFields = changedFields.add("principalid");
            return this;
        }

        public Builder principalentitymapid(String principalentitymapid) {
            this.principalentitymapid = principalentitymapid;
            this.changedFields = changedFields.add("principalentitymapid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Principalentitymap build() {
            Principalentitymap _x = new Principalentitymap();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.principalentitymap";
            _x.objecttypecode = objecttypecode;
            _x.principalid = principalid;
            _x.principalentitymapid = principalentitymapid;
            _x.versionnumber = versionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && principalentitymapid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(principalentitymapid.toString()));
        }
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<String> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Principalentitymap withObjecttypecode(String objecttypecode) {
        Checks.checkIsAscii(objecttypecode);
        Principalentitymap _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalentitymap");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="principalid")
    @JsonIgnore
    public Optional<String> getPrincipalid() {
        return Optional.ofNullable(principalid);
    }

    public Principalentitymap withPrincipalid(String principalid) {
        Principalentitymap _x = _copy();
        _x.changedFields = changedFields.add("principalid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalentitymap");
        _x.principalid = principalid;
        return _x;
    }

    @Property(name="principalentitymapid")
    @JsonIgnore
    public Optional<String> getPrincipalentitymapid() {
        return Optional.ofNullable(principalentitymapid);
    }

    public Principalentitymap withPrincipalentitymapid(String principalentitymapid) {
        Principalentitymap _x = _copy();
        _x.changedFields = changedFields.add("principalentitymapid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalentitymap");
        _x.principalentitymapid = principalentitymapid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Principalentitymap withVersionnumber(Long versionnumber) {
        Principalentitymap _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalentitymap");
        _x.versionnumber = versionnumber;
        return _x;
    }

    public Principalentitymap withUnmappedField(String name, String value) {
        Principalentitymap _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="principalid_owner")
    @JsonIgnore
    public PrincipalRequest getPrincipalid_owner() {
        return new PrincipalRequest(contextPath.addSegment("principalid_owner"), RequestHelper.getValue(unmappedFields, "principalid_owner"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Principalentitymap patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Principalentitymap _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Principalentitymap put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Principalentitymap _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Principalentitymap _copy() {
        Principalentitymap _x = new Principalentitymap();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.objecttypecode = objecttypecode;
        _x.principalid = principalid;
        _x.principalentitymapid = principalentitymapid;
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Principalentitymap[");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("principalid=");
        b.append(this.principalid);
        b.append(", ");
        b.append("principalentitymapid=");
        b.append(this.principalentitymapid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
