package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.ColumnmappingRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "modifiedon", 
    "createdon", 
    "componentstate", 
    "picklistmappingid", 
    "statuscode", 
    "sourcevalue", 
    "_createdonbehalfby_value", 
    "_modifiedonbehalfby_value", 
    "overwritetime", 
    "targetvalue", 
    "_columnmappingid_value", 
    "_modifiedby_value", 
    "solutionid", 
    "picklistmappingidunique", 
    "processcode", 
    "introducedversion", 
    "_createdby_value", 
    "statecode", 
    "ismanaged"})
@JsonInclude(Include.NON_NULL)
public class Picklistmapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.picklistmapping";
    }

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("picklistmappingid")
    protected String picklistmappingid;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("sourcevalue")
    protected String sourcevalue;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("targetvalue")
    protected Integer targetvalue;

    @JsonProperty("_columnmappingid_value")
    protected String _columnmappingid_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("picklistmappingidunique")
    protected String picklistmappingidunique;

    @JsonProperty("processcode")
    protected Integer processcode;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    protected Picklistmapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPicklistmapping() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime modifiedon;
        private OffsetDateTime createdon;
        private Integer componentstate;
        private String picklistmappingid;
        private Integer statuscode;
        private String sourcevalue;
        private String _createdonbehalfby_value;
        private String _modifiedonbehalfby_value;
        private OffsetDateTime overwritetime;
        private Integer targetvalue;
        private String _columnmappingid_value;
        private String _modifiedby_value;
        private String solutionid;
        private String picklistmappingidunique;
        private Integer processcode;
        private String introducedversion;
        private String _createdby_value;
        private Integer statecode;
        private Boolean ismanaged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder picklistmappingid(String picklistmappingid) {
            this.picklistmappingid = picklistmappingid;
            this.changedFields = changedFields.add("picklistmappingid");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder sourcevalue(String sourcevalue) {
            this.sourcevalue = sourcevalue;
            this.changedFields = changedFields.add("sourcevalue");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder targetvalue(Integer targetvalue) {
            this.targetvalue = targetvalue;
            this.changedFields = changedFields.add("targetvalue");
            return this;
        }

        public Builder _columnmappingid_value(String _columnmappingid_value) {
            this._columnmappingid_value = _columnmappingid_value;
            this.changedFields = changedFields.add("_columnmappingid_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder picklistmappingidunique(String picklistmappingidunique) {
            this.picklistmappingidunique = picklistmappingidunique;
            this.changedFields = changedFields.add("picklistmappingidunique");
            return this;
        }

        public Builder processcode(Integer processcode) {
            this.processcode = processcode;
            this.changedFields = changedFields.add("processcode");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Picklistmapping build() {
            Picklistmapping _x = new Picklistmapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.picklistmapping";
            _x.modifiedon = modifiedon;
            _x.createdon = createdon;
            _x.componentstate = componentstate;
            _x.picklistmappingid = picklistmappingid;
            _x.statuscode = statuscode;
            _x.sourcevalue = sourcevalue;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.overwritetime = overwritetime;
            _x.targetvalue = targetvalue;
            _x._columnmappingid_value = _columnmappingid_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.solutionid = solutionid;
            _x.picklistmappingidunique = picklistmappingidunique;
            _x.processcode = processcode;
            _x.introducedversion = introducedversion;
            _x._createdby_value = _createdby_value;
            _x.statecode = statecode;
            _x.ismanaged = ismanaged;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && picklistmappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(picklistmappingid.toString()));
        }
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Picklistmapping withModifiedon(OffsetDateTime modifiedon) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Picklistmapping withCreatedon(OffsetDateTime createdon) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Picklistmapping withComponentstate(Integer componentstate) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="picklistmappingid")
    @JsonIgnore
    public Optional<String> getPicklistmappingid() {
        return Optional.ofNullable(picklistmappingid);
    }

    public Picklistmapping withPicklistmappingid(String picklistmappingid) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("picklistmappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.picklistmappingid = picklistmappingid;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Picklistmapping withStatuscode(Integer statuscode) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="sourcevalue")
    @JsonIgnore
    public Optional<String> getSourcevalue() {
        return Optional.ofNullable(sourcevalue);
    }

    public Picklistmapping withSourcevalue(String sourcevalue) {
        Checks.checkIsAscii(sourcevalue);
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("sourcevalue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.sourcevalue = sourcevalue;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Picklistmapping with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Picklistmapping with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Picklistmapping withOverwritetime(OffsetDateTime overwritetime) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="targetvalue")
    @JsonIgnore
    public Optional<Integer> getTargetvalue() {
        return Optional.ofNullable(targetvalue);
    }

    public Picklistmapping withTargetvalue(Integer targetvalue) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("targetvalue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.targetvalue = targetvalue;
        return _x;
    }

    @Property(name="_columnmappingid_value")
    @JsonIgnore
    public Optional<String> get_columnmappingid_value() {
        return Optional.ofNullable(_columnmappingid_value);
    }

    public Picklistmapping with_columnmappingid_value(String _columnmappingid_value) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("_columnmappingid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x._columnmappingid_value = _columnmappingid_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Picklistmapping with_modifiedby_value(String _modifiedby_value) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Picklistmapping withSolutionid(String solutionid) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="picklistmappingidunique")
    @JsonIgnore
    public Optional<String> getPicklistmappingidunique() {
        return Optional.ofNullable(picklistmappingidunique);
    }

    public Picklistmapping withPicklistmappingidunique(String picklistmappingidunique) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("picklistmappingidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.picklistmappingidunique = picklistmappingidunique;
        return _x;
    }

    @Property(name="processcode")
    @JsonIgnore
    public Optional<Integer> getProcesscode() {
        return Optional.ofNullable(processcode);
    }

    public Picklistmapping withProcesscode(Integer processcode) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("processcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.processcode = processcode;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Picklistmapping withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Picklistmapping with_createdby_value(String _createdby_value) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Picklistmapping withStatecode(Integer statecode) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Picklistmapping withIsmanaged(Boolean ismanaged) {
        Picklistmapping _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.picklistmapping");
        _x.ismanaged = ismanaged;
        return _x;
    }

    public Picklistmapping withUnmappedField(String name, String value) {
        Picklistmapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="columnmappingid")
    @JsonIgnore
    public ColumnmappingRequest getColumnmappingid() {
        return new ColumnmappingRequest(contextPath.addSegment("columnmappingid"), RequestHelper.getValue(unmappedFields, "columnmappingid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Picklistmapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Picklistmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Picklistmapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Picklistmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Picklistmapping _copy() {
        Picklistmapping _x = new Picklistmapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.modifiedon = modifiedon;
        _x.createdon = createdon;
        _x.componentstate = componentstate;
        _x.picklistmappingid = picklistmappingid;
        _x.statuscode = statuscode;
        _x.sourcevalue = sourcevalue;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.overwritetime = overwritetime;
        _x.targetvalue = targetvalue;
        _x._columnmappingid_value = _columnmappingid_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.solutionid = solutionid;
        _x.picklistmappingidunique = picklistmappingidunique;
        _x.processcode = processcode;
        _x.introducedversion = introducedversion;
        _x._createdby_value = _createdby_value;
        _x.statecode = statecode;
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Picklistmapping[");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("picklistmappingid=");
        b.append(this.picklistmappingid);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("sourcevalue=");
        b.append(this.sourcevalue);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("targetvalue=");
        b.append(this.targetvalue);
        b.append(", ");
        b.append("_columnmappingid_value=");
        b.append(this._columnmappingid_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("picklistmappingidunique=");
        b.append(this.picklistmappingidunique);
        b.append(", ");
        b.append("processcode=");
        b.append(this.processcode);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
