package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdby_value", 
    "title", 
    "exchangerate", 
    "publicurl", 
    "_modifiedby_value", 
    "_organizationid_value", 
    "privateurl", 
    "modifiedon", 
    "knowledgebaserecordid", 
    "createdon", 
    "_modifiedonbehalfby_value", 
    "_createdonbehalfby_value", 
    "versionnumber", 
    "uniqueid", 
    "timezoneruleversionnumber", 
    "_transactioncurrencyid_value"})
@JsonInclude(Include.NON_NULL)
public class Knowledgebaserecord extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.knowledgebaserecord";
    }

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("publicurl")
    protected String publicurl;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("privateurl")
    protected String privateurl;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("knowledgebaserecordid")
    protected String knowledgebaserecordid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("uniqueid")
    protected String uniqueid;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    protected Knowledgebaserecord() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderKnowledgebaserecord() {
        return new Builder();
    }

    public static final class Builder {
        private String _createdby_value;
        private String title;
        private BigDecimal exchangerate;
        private String publicurl;
        private String _modifiedby_value;
        private String _organizationid_value;
        private String privateurl;
        private OffsetDateTime modifiedon;
        private String knowledgebaserecordid;
        private OffsetDateTime createdon;
        private String _modifiedonbehalfby_value;
        private String _createdonbehalfby_value;
        private Long versionnumber;
        private String uniqueid;
        private Integer timezoneruleversionnumber;
        private String _transactioncurrencyid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder publicurl(String publicurl) {
            this.publicurl = publicurl;
            this.changedFields = changedFields.add("publicurl");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder privateurl(String privateurl) {
            this.privateurl = privateurl;
            this.changedFields = changedFields.add("privateurl");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder knowledgebaserecordid(String knowledgebaserecordid) {
            this.knowledgebaserecordid = knowledgebaserecordid;
            this.changedFields = changedFields.add("knowledgebaserecordid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder uniqueid(String uniqueid) {
            this.uniqueid = uniqueid;
            this.changedFields = changedFields.add("uniqueid");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Knowledgebaserecord build() {
            Knowledgebaserecord _x = new Knowledgebaserecord();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.knowledgebaserecord";
            _x._createdby_value = _createdby_value;
            _x.title = title;
            _x.exchangerate = exchangerate;
            _x.publicurl = publicurl;
            _x._modifiedby_value = _modifiedby_value;
            _x._organizationid_value = _organizationid_value;
            _x.privateurl = privateurl;
            _x.modifiedon = modifiedon;
            _x.knowledgebaserecordid = knowledgebaserecordid;
            _x.createdon = createdon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.versionnumber = versionnumber;
            _x.uniqueid = uniqueid;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && knowledgebaserecordid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(knowledgebaserecordid.toString()));
        }
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Knowledgebaserecord with_createdby_value(String _createdby_value) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Knowledgebaserecord withTitle(String title) {
        Checks.checkIsAscii(title);
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.title = title;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Knowledgebaserecord withExchangerate(BigDecimal exchangerate) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="publicurl")
    @JsonIgnore
    public Optional<String> getPublicurl() {
        return Optional.ofNullable(publicurl);
    }

    public Knowledgebaserecord withPublicurl(String publicurl) {
        Checks.checkIsAscii(publicurl);
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("publicurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.publicurl = publicurl;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Knowledgebaserecord with_modifiedby_value(String _modifiedby_value) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Knowledgebaserecord with_organizationid_value(String _organizationid_value) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="privateurl")
    @JsonIgnore
    public Optional<String> getPrivateurl() {
        return Optional.ofNullable(privateurl);
    }

    public Knowledgebaserecord withPrivateurl(String privateurl) {
        Checks.checkIsAscii(privateurl);
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("privateurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.privateurl = privateurl;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Knowledgebaserecord withModifiedon(OffsetDateTime modifiedon) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="knowledgebaserecordid")
    @JsonIgnore
    public Optional<String> getKnowledgebaserecordid() {
        return Optional.ofNullable(knowledgebaserecordid);
    }

    public Knowledgebaserecord withKnowledgebaserecordid(String knowledgebaserecordid) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("knowledgebaserecordid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.knowledgebaserecordid = knowledgebaserecordid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Knowledgebaserecord withCreatedon(OffsetDateTime createdon) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Knowledgebaserecord with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Knowledgebaserecord with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Knowledgebaserecord withVersionnumber(Long versionnumber) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="uniqueid")
    @JsonIgnore
    public Optional<String> getUniqueid() {
        return Optional.ofNullable(uniqueid);
    }

    public Knowledgebaserecord withUniqueid(String uniqueid) {
        Checks.checkIsAscii(uniqueid);
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("uniqueid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.uniqueid = uniqueid;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Knowledgebaserecord withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Knowledgebaserecord with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Knowledgebaserecord _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgebaserecord");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    public Knowledgebaserecord withUnmappedField(String name, String value) {
        Knowledgebaserecord _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_ActivityPointers")
    @JsonIgnore
    public ActivitypointerCollectionRequest getKnowledgeBaseRecord_ActivityPointers() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_ActivityPointers"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_ActivityPointers"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_Appointments")
    @JsonIgnore
    public AppointmentCollectionRequest getKnowledgeBaseRecord_Appointments() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_Appointments"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_Appointments"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_Emails")
    @JsonIgnore
    public EmailCollectionRequest getKnowledgeBaseRecord_Emails() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_Emails"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_Emails"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_Faxes")
    @JsonIgnore
    public FaxCollectionRequest getKnowledgeBaseRecord_Faxes() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_Faxes"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_Faxes"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_Letters")
    @JsonIgnore
    public LetterCollectionRequest getKnowledgeBaseRecord_Letters() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_Letters"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_Letters"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_PhoneCalls")
    @JsonIgnore
    public PhonecallCollectionRequest getKnowledgeBaseRecord_PhoneCalls() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_PhoneCalls"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_PhoneCalls"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_Tasks")
    @JsonIgnore
    public TaskCollectionRequest getKnowledgeBaseRecord_Tasks() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_Tasks"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_Tasks"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_RecurringAppointmentMasters")
    @JsonIgnore
    public RecurringappointmentmasterCollectionRequest getKnowledgeBaseRecord_RecurringAppointmentMasters() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_RecurringAppointmentMasters"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_RecurringAppointmentMasters"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_SocialActivities")
    @JsonIgnore
    public SocialactivityCollectionRequest getKnowledgeBaseRecord_SocialActivities() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_SocialActivities"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_SocialActivities"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_connections1")
    @JsonIgnore
    public ConnectionCollectionRequest getKnowledgeBaseRecord_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_connections1"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_connections1"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_connections2")
    @JsonIgnore
    public ConnectionCollectionRequest getKnowledgeBaseRecord_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_connections2"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_connections2"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getKnowledgeBaseRecord_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getKnowledgeBaseRecord_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_Annotations")
    @JsonIgnore
    public AnnotationCollectionRequest getKnowledgeBaseRecord_Annotations() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_Annotations"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_Annotations"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getKnowledgeBaseRecord_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_AsyncOperations"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_AsyncOperations"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getKnowledgeBaseRecord_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_ProcessSession"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_ProcessSession"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getKnowledgeBaseRecord_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_BulkDeleteFailures"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_PrincipalObjectAttributeAccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getKnowledgeBaseRecord_PrincipalObjectAttributeAccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_PrincipalObjectAttributeAccess"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_PrincipalObjectAttributeAccess"));
    }

    @NavigationProperty(name="KnowledgeBaseRecord_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getKnowledgeBaseRecord_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("KnowledgeBaseRecord_SyncErrors"), RequestHelper.getValue(unmappedFields, "KnowledgeBaseRecord_SyncErrors"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Knowledgebaserecord patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Knowledgebaserecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Knowledgebaserecord put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Knowledgebaserecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Knowledgebaserecord _copy() {
        Knowledgebaserecord _x = new Knowledgebaserecord();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdby_value = _createdby_value;
        _x.title = title;
        _x.exchangerate = exchangerate;
        _x.publicurl = publicurl;
        _x._modifiedby_value = _modifiedby_value;
        _x._organizationid_value = _organizationid_value;
        _x.privateurl = privateurl;
        _x.modifiedon = modifiedon;
        _x.knowledgebaserecordid = knowledgebaserecordid;
        _x.createdon = createdon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.versionnumber = versionnumber;
        _x.uniqueid = uniqueid;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Knowledgebaserecord[");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("publicurl=");
        b.append(this.publicurl);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("privateurl=");
        b.append(this.privateurl);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("knowledgebaserecordid=");
        b.append(this.knowledgebaserecordid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("uniqueid=");
        b.append(this.uniqueid);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
