package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ImportdataRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdonbehalfby_value", 
    "_ownerid_value", 
    "statecode", 
    "_modifiedonbehalfby_value", 
    "columnvalue", 
    "statuscode", 
    "_owningteam_value", 
    "_modifiedby_value", 
    "_owningbusinessunit_value", 
    "headercolumn", 
    "errordescription", 
    "sequencenumber", 
    "_importfileid_value", 
    "_createdby_value", 
    "additionalinfo", 
    "_owninguser_value", 
    "linenumber", 
    "importlogid", 
    "errornumber", 
    "modifiedon", 
    "logphasecode", 
    "createdon", 
    "_importdataid_value"})
@JsonInclude(Include.NON_NULL)
public class Importlog extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.importlog";
    }

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("columnvalue")
    protected String columnvalue;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("headercolumn")
    protected String headercolumn;

    @JsonProperty("errordescription")
    protected String errordescription;

    @JsonProperty("sequencenumber")
    protected Integer sequencenumber;

    @JsonProperty("_importfileid_value")
    protected String _importfileid_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("additionalinfo")
    protected String additionalinfo;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("linenumber")
    protected Integer linenumber;

    @JsonProperty("importlogid")
    protected String importlogid;

    @JsonProperty("errornumber")
    protected Integer errornumber;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("logphasecode")
    protected Integer logphasecode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_importdataid_value")
    protected String _importdataid_value;

    protected Importlog() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportlog() {
        return new Builder();
    }

    public static final class Builder {
        private String _createdonbehalfby_value;
        private String _ownerid_value;
        private Integer statecode;
        private String _modifiedonbehalfby_value;
        private String columnvalue;
        private Integer statuscode;
        private String _owningteam_value;
        private String _modifiedby_value;
        private String _owningbusinessunit_value;
        private String headercolumn;
        private String errordescription;
        private Integer sequencenumber;
        private String _importfileid_value;
        private String _createdby_value;
        private String additionalinfo;
        private String _owninguser_value;
        private Integer linenumber;
        private String importlogid;
        private Integer errornumber;
        private OffsetDateTime modifiedon;
        private Integer logphasecode;
        private OffsetDateTime createdon;
        private String _importdataid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder columnvalue(String columnvalue) {
            this.columnvalue = columnvalue;
            this.changedFields = changedFields.add("columnvalue");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder headercolumn(String headercolumn) {
            this.headercolumn = headercolumn;
            this.changedFields = changedFields.add("headercolumn");
            return this;
        }

        public Builder errordescription(String errordescription) {
            this.errordescription = errordescription;
            this.changedFields = changedFields.add("errordescription");
            return this;
        }

        public Builder sequencenumber(Integer sequencenumber) {
            this.sequencenumber = sequencenumber;
            this.changedFields = changedFields.add("sequencenumber");
            return this;
        }

        public Builder _importfileid_value(String _importfileid_value) {
            this._importfileid_value = _importfileid_value;
            this.changedFields = changedFields.add("_importfileid_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder additionalinfo(String additionalinfo) {
            this.additionalinfo = additionalinfo;
            this.changedFields = changedFields.add("additionalinfo");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder linenumber(Integer linenumber) {
            this.linenumber = linenumber;
            this.changedFields = changedFields.add("linenumber");
            return this;
        }

        public Builder importlogid(String importlogid) {
            this.importlogid = importlogid;
            this.changedFields = changedFields.add("importlogid");
            return this;
        }

        public Builder errornumber(Integer errornumber) {
            this.errornumber = errornumber;
            this.changedFields = changedFields.add("errornumber");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder logphasecode(Integer logphasecode) {
            this.logphasecode = logphasecode;
            this.changedFields = changedFields.add("logphasecode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _importdataid_value(String _importdataid_value) {
            this._importdataid_value = _importdataid_value;
            this.changedFields = changedFields.add("_importdataid_value");
            return this;
        }

        public Importlog build() {
            Importlog _x = new Importlog();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.importlog";
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._ownerid_value = _ownerid_value;
            _x.statecode = statecode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.columnvalue = columnvalue;
            _x.statuscode = statuscode;
            _x._owningteam_value = _owningteam_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.headercolumn = headercolumn;
            _x.errordescription = errordescription;
            _x.sequencenumber = sequencenumber;
            _x._importfileid_value = _importfileid_value;
            _x._createdby_value = _createdby_value;
            _x.additionalinfo = additionalinfo;
            _x._owninguser_value = _owninguser_value;
            _x.linenumber = linenumber;
            _x.importlogid = importlogid;
            _x.errornumber = errornumber;
            _x.modifiedon = modifiedon;
            _x.logphasecode = logphasecode;
            _x.createdon = createdon;
            _x._importdataid_value = _importdataid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && importlogid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(importlogid.toString()));
        }
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Importlog with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Importlog with_ownerid_value(String _ownerid_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Importlog withStatecode(Integer statecode) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Importlog with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="columnvalue")
    @JsonIgnore
    public Optional<String> getColumnvalue() {
        return Optional.ofNullable(columnvalue);
    }

    public Importlog withColumnvalue(String columnvalue) {
        Checks.checkIsAscii(columnvalue);
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("columnvalue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.columnvalue = columnvalue;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Importlog withStatuscode(Integer statuscode) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Importlog with_owningteam_value(String _owningteam_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Importlog with_modifiedby_value(String _modifiedby_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Importlog with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="headercolumn")
    @JsonIgnore
    public Optional<String> getHeadercolumn() {
        return Optional.ofNullable(headercolumn);
    }

    public Importlog withHeadercolumn(String headercolumn) {
        Checks.checkIsAscii(headercolumn);
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("headercolumn");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.headercolumn = headercolumn;
        return _x;
    }

    @Property(name="errordescription")
    @JsonIgnore
    public Optional<String> getErrordescription() {
        return Optional.ofNullable(errordescription);
    }

    public Importlog withErrordescription(String errordescription) {
        Checks.checkIsAscii(errordescription);
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("errordescription");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.errordescription = errordescription;
        return _x;
    }

    @Property(name="sequencenumber")
    @JsonIgnore
    public Optional<Integer> getSequencenumber() {
        return Optional.ofNullable(sequencenumber);
    }

    public Importlog withSequencenumber(Integer sequencenumber) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("sequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.sequencenumber = sequencenumber;
        return _x;
    }

    @Property(name="_importfileid_value")
    @JsonIgnore
    public Optional<String> get_importfileid_value() {
        return Optional.ofNullable(_importfileid_value);
    }

    public Importlog with_importfileid_value(String _importfileid_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_importfileid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._importfileid_value = _importfileid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Importlog with_createdby_value(String _createdby_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="additionalinfo")
    @JsonIgnore
    public Optional<String> getAdditionalinfo() {
        return Optional.ofNullable(additionalinfo);
    }

    public Importlog withAdditionalinfo(String additionalinfo) {
        Checks.checkIsAscii(additionalinfo);
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("additionalinfo");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.additionalinfo = additionalinfo;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Importlog with_owninguser_value(String _owninguser_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="linenumber")
    @JsonIgnore
    public Optional<Integer> getLinenumber() {
        return Optional.ofNullable(linenumber);
    }

    public Importlog withLinenumber(Integer linenumber) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("linenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.linenumber = linenumber;
        return _x;
    }

    @Property(name="importlogid")
    @JsonIgnore
    public Optional<String> getImportlogid() {
        return Optional.ofNullable(importlogid);
    }

    public Importlog withImportlogid(String importlogid) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("importlogid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.importlogid = importlogid;
        return _x;
    }

    @Property(name="errornumber")
    @JsonIgnore
    public Optional<Integer> getErrornumber() {
        return Optional.ofNullable(errornumber);
    }

    public Importlog withErrornumber(Integer errornumber) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("errornumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.errornumber = errornumber;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Importlog withModifiedon(OffsetDateTime modifiedon) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="logphasecode")
    @JsonIgnore
    public Optional<Integer> getLogphasecode() {
        return Optional.ofNullable(logphasecode);
    }

    public Importlog withLogphasecode(Integer logphasecode) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("logphasecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.logphasecode = logphasecode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Importlog withCreatedon(OffsetDateTime createdon) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_importdataid_value")
    @JsonIgnore
    public Optional<String> get_importdataid_value() {
        return Optional.ofNullable(_importdataid_value);
    }

    public Importlog with_importdataid_value(String _importdataid_value) {
        Importlog _x = _copy();
        _x.changedFields = changedFields.add("_importdataid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importlog");
        _x._importdataid_value = _importdataid_value;
        return _x;
    }

    public Importlog withUnmappedField(String name, String value) {
        Importlog _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="ImportLog_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getImportLog_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ImportLog_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "ImportLog_BulkDeleteFailures"));
    }

    @NavigationProperty(name="importdataid")
    @JsonIgnore
    public ImportdataRequest getImportdataid() {
        return new ImportdataRequest(contextPath.addSegment("importdataid"), RequestHelper.getValue(unmappedFields, "importdataid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ImportLog_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getImportLog_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ImportLog_AsyncOperations"), RequestHelper.getValue(unmappedFields, "ImportLog_AsyncOperations"));
    }

    @NavigationProperty(name="importfileid")
    @JsonIgnore
    public ImportfileRequest getImportfileid() {
        return new ImportfileRequest(contextPath.addSegment("importfileid"), RequestHelper.getValue(unmappedFields, "importfileid"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importlog patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Importlog _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importlog put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Importlog _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Importlog _copy() {
        Importlog _x = new Importlog();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._ownerid_value = _ownerid_value;
        _x.statecode = statecode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.columnvalue = columnvalue;
        _x.statuscode = statuscode;
        _x._owningteam_value = _owningteam_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.headercolumn = headercolumn;
        _x.errordescription = errordescription;
        _x.sequencenumber = sequencenumber;
        _x._importfileid_value = _importfileid_value;
        _x._createdby_value = _createdby_value;
        _x.additionalinfo = additionalinfo;
        _x._owninguser_value = _owninguser_value;
        _x.linenumber = linenumber;
        _x.importlogid = importlogid;
        _x.errornumber = errornumber;
        _x.modifiedon = modifiedon;
        _x.logphasecode = logphasecode;
        _x.createdon = createdon;
        _x._importdataid_value = _importdataid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Importlog[");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("columnvalue=");
        b.append(this.columnvalue);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("headercolumn=");
        b.append(this.headercolumn);
        b.append(", ");
        b.append("errordescription=");
        b.append(this.errordescription);
        b.append(", ");
        b.append("sequencenumber=");
        b.append(this.sequencenumber);
        b.append(", ");
        b.append("_importfileid_value=");
        b.append(this._importfileid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("additionalinfo=");
        b.append(this.additionalinfo);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("linenumber=");
        b.append(this.linenumber);
        b.append(", ");
        b.append("importlogid=");
        b.append(this.importlogid);
        b.append(", ");
        b.append("errornumber=");
        b.append(this.errornumber);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("logphasecode=");
        b.append(this.logphasecode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_importdataid_value=");
        b.append(this._importdataid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
