package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.EntityRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_parententityid_value", 
    "ismanaged", 
    "versionnumber", 
    "isenabledfortimeseries", 
    "overwritetime", 
    "parententitylogicalname", 
    "componentidunique", 
    "solutionid", 
    "isenabledforadls", 
    "entityanalyticsconfigid", 
    "componentstate", 
    "_organizationid_value"})
@JsonInclude(Include.NON_NULL)
public class Entityanalyticsconfig extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.entityanalyticsconfig";
    }

    @JsonProperty("_parententityid_value")
    protected String _parententityid_value;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("isenabledfortimeseries")
    protected Boolean isenabledfortimeseries;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("parententitylogicalname")
    protected String parententitylogicalname;

    @JsonProperty("componentidunique")
    protected String componentidunique;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("isenabledforadls")
    protected Boolean isenabledforadls;

    @JsonProperty("entityanalyticsconfigid")
    protected String entityanalyticsconfigid;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    protected Entityanalyticsconfig() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntityanalyticsconfig() {
        return new Builder();
    }

    public static final class Builder {
        private String _parententityid_value;
        private Boolean ismanaged;
        private Long versionnumber;
        private Boolean isenabledfortimeseries;
        private OffsetDateTime overwritetime;
        private String parententitylogicalname;
        private String componentidunique;
        private String solutionid;
        private Boolean isenabledforadls;
        private String entityanalyticsconfigid;
        private Integer componentstate;
        private String _organizationid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _parententityid_value(String _parententityid_value) {
            this._parententityid_value = _parententityid_value;
            this.changedFields = changedFields.add("_parententityid_value");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder isenabledfortimeseries(Boolean isenabledfortimeseries) {
            this.isenabledfortimeseries = isenabledfortimeseries;
            this.changedFields = changedFields.add("isenabledfortimeseries");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder parententitylogicalname(String parententitylogicalname) {
            this.parententitylogicalname = parententitylogicalname;
            this.changedFields = changedFields.add("parententitylogicalname");
            return this;
        }

        public Builder componentidunique(String componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder isenabledforadls(Boolean isenabledforadls) {
            this.isenabledforadls = isenabledforadls;
            this.changedFields = changedFields.add("isenabledforadls");
            return this;
        }

        public Builder entityanalyticsconfigid(String entityanalyticsconfigid) {
            this.entityanalyticsconfigid = entityanalyticsconfigid;
            this.changedFields = changedFields.add("entityanalyticsconfigid");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Entityanalyticsconfig build() {
            Entityanalyticsconfig _x = new Entityanalyticsconfig();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.entityanalyticsconfig";
            _x._parententityid_value = _parententityid_value;
            _x.ismanaged = ismanaged;
            _x.versionnumber = versionnumber;
            _x.isenabledfortimeseries = isenabledfortimeseries;
            _x.overwritetime = overwritetime;
            _x.parententitylogicalname = parententitylogicalname;
            _x.componentidunique = componentidunique;
            _x.solutionid = solutionid;
            _x.isenabledforadls = isenabledforadls;
            _x.entityanalyticsconfigid = entityanalyticsconfigid;
            _x.componentstate = componentstate;
            _x._organizationid_value = _organizationid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && entityanalyticsconfigid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(entityanalyticsconfigid.toString()));
        }
    }

    @Property(name="_parententityid_value")
    @JsonIgnore
    public Optional<String> get_parententityid_value() {
        return Optional.ofNullable(_parententityid_value);
    }

    public Entityanalyticsconfig with_parententityid_value(String _parententityid_value) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("_parententityid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x._parententityid_value = _parententityid_value;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Entityanalyticsconfig withIsmanaged(Boolean ismanaged) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Entityanalyticsconfig withVersionnumber(Long versionnumber) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="isenabledfortimeseries")
    @JsonIgnore
    public Optional<Boolean> getIsenabledfortimeseries() {
        return Optional.ofNullable(isenabledfortimeseries);
    }

    public Entityanalyticsconfig withIsenabledfortimeseries(Boolean isenabledfortimeseries) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("isenabledfortimeseries");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.isenabledfortimeseries = isenabledfortimeseries;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Entityanalyticsconfig withOverwritetime(OffsetDateTime overwritetime) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="parententitylogicalname")
    @JsonIgnore
    public Optional<String> getParententitylogicalname() {
        return Optional.ofNullable(parententitylogicalname);
    }

    public Entityanalyticsconfig withParententitylogicalname(String parententitylogicalname) {
        Checks.checkIsAscii(parententitylogicalname);
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("parententitylogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.parententitylogicalname = parententitylogicalname;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<String> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Entityanalyticsconfig withComponentidunique(String componentidunique) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Entityanalyticsconfig withSolutionid(String solutionid) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="isenabledforadls")
    @JsonIgnore
    public Optional<Boolean> getIsenabledforadls() {
        return Optional.ofNullable(isenabledforadls);
    }

    public Entityanalyticsconfig withIsenabledforadls(Boolean isenabledforadls) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("isenabledforadls");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.isenabledforadls = isenabledforadls;
        return _x;
    }

    @Property(name="entityanalyticsconfigid")
    @JsonIgnore
    public Optional<String> getEntityanalyticsconfigid() {
        return Optional.ofNullable(entityanalyticsconfigid);
    }

    public Entityanalyticsconfig withEntityanalyticsconfigid(String entityanalyticsconfigid) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("entityanalyticsconfigid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.entityanalyticsconfigid = entityanalyticsconfigid;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Entityanalyticsconfig withComponentstate(Integer componentstate) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Entityanalyticsconfig with_organizationid_value(String _organizationid_value) {
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityanalyticsconfig");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    public Entityanalyticsconfig withUnmappedField(String name, String value) {
        Entityanalyticsconfig _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="entityanalyticsconfig_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getEntityanalyticsconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_SyncErrors"), RequestHelper.getValue(unmappedFields, "entityanalyticsconfig_SyncErrors"));
    }

    @NavigationProperty(name="entityanalyticsconfig_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getEntityanalyticsconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_AsyncOperations"), RequestHelper.getValue(unmappedFields, "entityanalyticsconfig_AsyncOperations"));
    }

    @NavigationProperty(name="entityanalyticsconfig_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getEntityanalyticsconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "entityanalyticsconfig_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="entityanalyticsconfig_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getEntityanalyticsconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "entityanalyticsconfig_BulkDeleteFailures"));
    }

    @NavigationProperty(name="entityanalyticsconfig_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getEntityanalyticsconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "entityanalyticsconfig_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="parententityid")
    @JsonIgnore
    public EntityRequest getParententityid() {
        return new EntityRequest(contextPath.addSegment("parententityid"), RequestHelper.getValue(unmappedFields, "parententityid"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entityanalyticsconfig patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entityanalyticsconfig put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Entityanalyticsconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Entityanalyticsconfig _copy() {
        Entityanalyticsconfig _x = new Entityanalyticsconfig();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._parententityid_value = _parententityid_value;
        _x.ismanaged = ismanaged;
        _x.versionnumber = versionnumber;
        _x.isenabledfortimeseries = isenabledfortimeseries;
        _x.overwritetime = overwritetime;
        _x.parententitylogicalname = parententitylogicalname;
        _x.componentidunique = componentidunique;
        _x.solutionid = solutionid;
        _x.isenabledforadls = isenabledforadls;
        _x.entityanalyticsconfigid = entityanalyticsconfigid;
        _x.componentstate = componentstate;
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Entityanalyticsconfig[");
        b.append("_parententityid_value=");
        b.append(this._parententityid_value);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("isenabledfortimeseries=");
        b.append(this.isenabledfortimeseries);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("parententitylogicalname=");
        b.append(this.parententitylogicalname);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("isenabledforadls=");
        b.append(this.isenabledforadls);
        b.append(", ");
        b.append("entityanalyticsconfigid=");
        b.append(this.entityanalyticsconfigid);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
