package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "addressusedemailcolumnnumber", 
    "scheduledend", 
    "effort", 
    "instancetypecode", 
    "donotfax", 
    "addressused", 
    "scheduledstart", 
    "_partyid_value", 
    "_activityid_value", 
    "exchangeentryid", 
    "donotphone", 
    "versionnumber", 
    "participationtypemask", 
    "ispartydeleted", 
    "_ownerid_value", 
    "donotpostalmail", 
    "activitypartyid", 
    "donotemail"})
@JsonInclude(Include.NON_NULL)
public class Activityparty extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.activityparty";
    }

    @JsonProperty("addressusedemailcolumnnumber")
    protected Integer addressusedemailcolumnnumber;

    @JsonProperty("scheduledend")
    protected OffsetDateTime scheduledend;

    @JsonProperty("effort")
    protected Double effort;

    @JsonProperty("instancetypecode")
    protected Integer instancetypecode;

    @JsonProperty("donotfax")
    protected Boolean donotfax;

    @JsonProperty("addressused")
    protected String addressused;

    @JsonProperty("scheduledstart")
    protected OffsetDateTime scheduledstart;

    @JsonProperty("_partyid_value")
    protected String _partyid_value;

    @JsonProperty("_activityid_value")
    protected String _activityid_value;

    @JsonProperty("exchangeentryid")
    protected String exchangeentryid;

    @JsonProperty("donotphone")
    protected Boolean donotphone;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("participationtypemask")
    protected Integer participationtypemask;

    @JsonProperty("ispartydeleted")
    protected Boolean ispartydeleted;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("donotpostalmail")
    protected Boolean donotpostalmail;

    @JsonProperty("activitypartyid")
    protected String activitypartyid;

    @JsonProperty("donotemail")
    protected Boolean donotemail;

    protected Activityparty() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderActivityparty() {
        return new Builder();
    }

    public static final class Builder {
        private Integer addressusedemailcolumnnumber;
        private OffsetDateTime scheduledend;
        private Double effort;
        private Integer instancetypecode;
        private Boolean donotfax;
        private String addressused;
        private OffsetDateTime scheduledstart;
        private String _partyid_value;
        private String _activityid_value;
        private String exchangeentryid;
        private Boolean donotphone;
        private Long versionnumber;
        private Integer participationtypemask;
        private Boolean ispartydeleted;
        private String _ownerid_value;
        private Boolean donotpostalmail;
        private String activitypartyid;
        private Boolean donotemail;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder addressusedemailcolumnnumber(Integer addressusedemailcolumnnumber) {
            this.addressusedemailcolumnnumber = addressusedemailcolumnnumber;
            this.changedFields = changedFields.add("addressusedemailcolumnnumber");
            return this;
        }

        public Builder scheduledend(OffsetDateTime scheduledend) {
            this.scheduledend = scheduledend;
            this.changedFields = changedFields.add("scheduledend");
            return this;
        }

        public Builder effort(Double effort) {
            this.effort = effort;
            this.changedFields = changedFields.add("effort");
            return this;
        }

        public Builder instancetypecode(Integer instancetypecode) {
            this.instancetypecode = instancetypecode;
            this.changedFields = changedFields.add("instancetypecode");
            return this;
        }

        public Builder donotfax(Boolean donotfax) {
            this.donotfax = donotfax;
            this.changedFields = changedFields.add("donotfax");
            return this;
        }

        public Builder addressused(String addressused) {
            this.addressused = addressused;
            this.changedFields = changedFields.add("addressused");
            return this;
        }

        public Builder scheduledstart(OffsetDateTime scheduledstart) {
            this.scheduledstart = scheduledstart;
            this.changedFields = changedFields.add("scheduledstart");
            return this;
        }

        public Builder _partyid_value(String _partyid_value) {
            this._partyid_value = _partyid_value;
            this.changedFields = changedFields.add("_partyid_value");
            return this;
        }

        public Builder _activityid_value(String _activityid_value) {
            this._activityid_value = _activityid_value;
            this.changedFields = changedFields.add("_activityid_value");
            return this;
        }

        public Builder exchangeentryid(String exchangeentryid) {
            this.exchangeentryid = exchangeentryid;
            this.changedFields = changedFields.add("exchangeentryid");
            return this;
        }

        public Builder donotphone(Boolean donotphone) {
            this.donotphone = donotphone;
            this.changedFields = changedFields.add("donotphone");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder participationtypemask(Integer participationtypemask) {
            this.participationtypemask = participationtypemask;
            this.changedFields = changedFields.add("participationtypemask");
            return this;
        }

        public Builder ispartydeleted(Boolean ispartydeleted) {
            this.ispartydeleted = ispartydeleted;
            this.changedFields = changedFields.add("ispartydeleted");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder donotpostalmail(Boolean donotpostalmail) {
            this.donotpostalmail = donotpostalmail;
            this.changedFields = changedFields.add("donotpostalmail");
            return this;
        }

        public Builder activitypartyid(String activitypartyid) {
            this.activitypartyid = activitypartyid;
            this.changedFields = changedFields.add("activitypartyid");
            return this;
        }

        public Builder donotemail(Boolean donotemail) {
            this.donotemail = donotemail;
            this.changedFields = changedFields.add("donotemail");
            return this;
        }

        public Activityparty build() {
            Activityparty _x = new Activityparty();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.activityparty";
            _x.addressusedemailcolumnnumber = addressusedemailcolumnnumber;
            _x.scheduledend = scheduledend;
            _x.effort = effort;
            _x.instancetypecode = instancetypecode;
            _x.donotfax = donotfax;
            _x.addressused = addressused;
            _x.scheduledstart = scheduledstart;
            _x._partyid_value = _partyid_value;
            _x._activityid_value = _activityid_value;
            _x.exchangeentryid = exchangeentryid;
            _x.donotphone = donotphone;
            _x.versionnumber = versionnumber;
            _x.participationtypemask = participationtypemask;
            _x.ispartydeleted = ispartydeleted;
            _x._ownerid_value = _ownerid_value;
            _x.donotpostalmail = donotpostalmail;
            _x.activitypartyid = activitypartyid;
            _x.donotemail = donotemail;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && activitypartyid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(activitypartyid.toString()));
        }
    }

    @Property(name="addressusedemailcolumnnumber")
    @JsonIgnore
    public Optional<Integer> getAddressusedemailcolumnnumber() {
        return Optional.ofNullable(addressusedemailcolumnnumber);
    }

    public Activityparty withAddressusedemailcolumnnumber(Integer addressusedemailcolumnnumber) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("addressusedemailcolumnnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.addressusedemailcolumnnumber = addressusedemailcolumnnumber;
        return _x;
    }

    @Property(name="scheduledend")
    @JsonIgnore
    public Optional<OffsetDateTime> getScheduledend() {
        return Optional.ofNullable(scheduledend);
    }

    public Activityparty withScheduledend(OffsetDateTime scheduledend) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("scheduledend");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.scheduledend = scheduledend;
        return _x;
    }

    @Property(name="effort")
    @JsonIgnore
    public Optional<Double> getEffort() {
        return Optional.ofNullable(effort);
    }

    public Activityparty withEffort(Double effort) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("effort");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.effort = effort;
        return _x;
    }

    @Property(name="instancetypecode")
    @JsonIgnore
    public Optional<Integer> getInstancetypecode() {
        return Optional.ofNullable(instancetypecode);
    }

    public Activityparty withInstancetypecode(Integer instancetypecode) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("instancetypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.instancetypecode = instancetypecode;
        return _x;
    }

    @Property(name="donotfax")
    @JsonIgnore
    public Optional<Boolean> getDonotfax() {
        return Optional.ofNullable(donotfax);
    }

    public Activityparty withDonotfax(Boolean donotfax) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("donotfax");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.donotfax = donotfax;
        return _x;
    }

    @Property(name="addressused")
    @JsonIgnore
    public Optional<String> getAddressused() {
        return Optional.ofNullable(addressused);
    }

    public Activityparty withAddressused(String addressused) {
        Checks.checkIsAscii(addressused);
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("addressused");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.addressused = addressused;
        return _x;
    }

    @Property(name="scheduledstart")
    @JsonIgnore
    public Optional<OffsetDateTime> getScheduledstart() {
        return Optional.ofNullable(scheduledstart);
    }

    public Activityparty withScheduledstart(OffsetDateTime scheduledstart) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("scheduledstart");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.scheduledstart = scheduledstart;
        return _x;
    }

    @Property(name="_partyid_value")
    @JsonIgnore
    public Optional<String> get_partyid_value() {
        return Optional.ofNullable(_partyid_value);
    }

    public Activityparty with_partyid_value(String _partyid_value) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("_partyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x._partyid_value = _partyid_value;
        return _x;
    }

    @Property(name="_activityid_value")
    @JsonIgnore
    public Optional<String> get_activityid_value() {
        return Optional.ofNullable(_activityid_value);
    }

    public Activityparty with_activityid_value(String _activityid_value) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("_activityid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x._activityid_value = _activityid_value;
        return _x;
    }

    @Property(name="exchangeentryid")
    @JsonIgnore
    public Optional<String> getExchangeentryid() {
        return Optional.ofNullable(exchangeentryid);
    }

    public Activityparty withExchangeentryid(String exchangeentryid) {
        Checks.checkIsAscii(exchangeentryid);
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("exchangeentryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.exchangeentryid = exchangeentryid;
        return _x;
    }

    @Property(name="donotphone")
    @JsonIgnore
    public Optional<Boolean> getDonotphone() {
        return Optional.ofNullable(donotphone);
    }

    public Activityparty withDonotphone(Boolean donotphone) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("donotphone");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.donotphone = donotphone;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Activityparty withVersionnumber(Long versionnumber) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="participationtypemask")
    @JsonIgnore
    public Optional<Integer> getParticipationtypemask() {
        return Optional.ofNullable(participationtypemask);
    }

    public Activityparty withParticipationtypemask(Integer participationtypemask) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("participationtypemask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.participationtypemask = participationtypemask;
        return _x;
    }

    @Property(name="ispartydeleted")
    @JsonIgnore
    public Optional<Boolean> getIspartydeleted() {
        return Optional.ofNullable(ispartydeleted);
    }

    public Activityparty withIspartydeleted(Boolean ispartydeleted) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("ispartydeleted");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.ispartydeleted = ispartydeleted;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Activityparty with_ownerid_value(String _ownerid_value) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="donotpostalmail")
    @JsonIgnore
    public Optional<Boolean> getDonotpostalmail() {
        return Optional.ofNullable(donotpostalmail);
    }

    public Activityparty withDonotpostalmail(Boolean donotpostalmail) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("donotpostalmail");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.donotpostalmail = donotpostalmail;
        return _x;
    }

    @Property(name="activitypartyid")
    @JsonIgnore
    public Optional<String> getActivitypartyid() {
        return Optional.ofNullable(activitypartyid);
    }

    public Activityparty withActivitypartyid(String activitypartyid) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("activitypartyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.activitypartyid = activitypartyid;
        return _x;
    }

    @Property(name="donotemail")
    @JsonIgnore
    public Optional<Boolean> getDonotemail() {
        return Optional.ofNullable(donotemail);
    }

    public Activityparty withDonotemail(Boolean donotemail) {
        Activityparty _x = _copy();
        _x.changedFields = changedFields.add("donotemail");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.activityparty");
        _x.donotemail = donotemail;
        return _x;
    }

    public Activityparty withUnmappedField(String name, String value) {
        Activityparty _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="ActivityParty_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getActivityParty_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ActivityParty_SyncErrors"), RequestHelper.getValue(unmappedFields, "ActivityParty_SyncErrors"));
    }

    @NavigationProperty(name="activityid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getActivityid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("activityid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "activityid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="activityid_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getActivityid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("activityid_socialactivity"), RequestHelper.getValue(unmappedFields, "activityid_socialactivity"));
    }

    @NavigationProperty(name="activityid_appointment")
    @JsonIgnore
    public AppointmentRequest getActivityid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("activityid_appointment"), RequestHelper.getValue(unmappedFields, "activityid_appointment"));
    }

    @NavigationProperty(name="partyid_queue")
    @JsonIgnore
    public QueueRequest getPartyid_queue() {
        return new QueueRequest(contextPath.addSegment("partyid_queue"), RequestHelper.getValue(unmappedFields, "partyid_queue"));
    }

    @NavigationProperty(name="partyid_systemuser")
    @JsonIgnore
    public SystemuserRequest getPartyid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("partyid_systemuser"), RequestHelper.getValue(unmappedFields, "partyid_systemuser"));
    }

    @NavigationProperty(name="activityid_fax")
    @JsonIgnore
    public FaxRequest getActivityid_fax() {
        return new FaxRequest(contextPath.addSegment("activityid_fax"), RequestHelper.getValue(unmappedFields, "activityid_fax"));
    }

    @NavigationProperty(name="activityid_phonecall")
    @JsonIgnore
    public PhonecallRequest getActivityid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("activityid_phonecall"), RequestHelper.getValue(unmappedFields, "activityid_phonecall"));
    }

    @NavigationProperty(name="activityid_task")
    @JsonIgnore
    public TaskRequest getActivityid_task() {
        return new TaskRequest(contextPath.addSegment("activityid_task"), RequestHelper.getValue(unmappedFields, "activityid_task"));
    }

    @NavigationProperty(name="activityid_letter")
    @JsonIgnore
    public LetterRequest getActivityid_letter() {
        return new LetterRequest(contextPath.addSegment("activityid_letter"), RequestHelper.getValue(unmappedFields, "activityid_letter"));
    }

    @NavigationProperty(name="activityid_email")
    @JsonIgnore
    public EmailRequest getActivityid_email() {
        return new EmailRequest(contextPath.addSegment("activityid_email"), RequestHelper.getValue(unmappedFields, "activityid_email"));
    }

    @NavigationProperty(name="partyid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getPartyid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("partyid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "partyid_knowledgearticle"));
    }

    @NavigationProperty(name="partyid_account")
    @JsonIgnore
    public AccountRequest getPartyid_account() {
        return new AccountRequest(contextPath.addSegment("partyid_account"), RequestHelper.getValue(unmappedFields, "partyid_account"));
    }

    @NavigationProperty(name="activityid_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getActivityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), RequestHelper.getValue(unmappedFields, "activityid_activitypointer"));
    }

    @NavigationProperty(name="partyid_contact")
    @JsonIgnore
    public ContactRequest getPartyid_contact() {
        return new ContactRequest(contextPath.addSegment("partyid_contact"), RequestHelper.getValue(unmappedFields, "partyid_contact"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Activityparty patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Activityparty _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Activityparty put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Activityparty _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Activityparty _copy() {
        Activityparty _x = new Activityparty();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.addressusedemailcolumnnumber = addressusedemailcolumnnumber;
        _x.scheduledend = scheduledend;
        _x.effort = effort;
        _x.instancetypecode = instancetypecode;
        _x.donotfax = donotfax;
        _x.addressused = addressused;
        _x.scheduledstart = scheduledstart;
        _x._partyid_value = _partyid_value;
        _x._activityid_value = _activityid_value;
        _x.exchangeentryid = exchangeentryid;
        _x.donotphone = donotphone;
        _x.versionnumber = versionnumber;
        _x.participationtypemask = participationtypemask;
        _x.ispartydeleted = ispartydeleted;
        _x._ownerid_value = _ownerid_value;
        _x.donotpostalmail = donotpostalmail;
        _x.activitypartyid = activitypartyid;
        _x.donotemail = donotemail;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Activityparty[");
        b.append("addressusedemailcolumnnumber=");
        b.append(this.addressusedemailcolumnnumber);
        b.append(", ");
        b.append("scheduledend=");
        b.append(this.scheduledend);
        b.append(", ");
        b.append("effort=");
        b.append(this.effort);
        b.append(", ");
        b.append("instancetypecode=");
        b.append(this.instancetypecode);
        b.append(", ");
        b.append("donotfax=");
        b.append(this.donotfax);
        b.append(", ");
        b.append("addressused=");
        b.append(this.addressused);
        b.append(", ");
        b.append("scheduledstart=");
        b.append(this.scheduledstart);
        b.append(", ");
        b.append("_partyid_value=");
        b.append(this._partyid_value);
        b.append(", ");
        b.append("_activityid_value=");
        b.append(this._activityid_value);
        b.append(", ");
        b.append("exchangeentryid=");
        b.append(this.exchangeentryid);
        b.append(", ");
        b.append("donotphone=");
        b.append(this.donotphone);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("participationtypemask=");
        b.append(this.participationtypemask);
        b.append(", ");
        b.append("ispartydeleted=");
        b.append(this.ispartydeleted);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("donotpostalmail=");
        b.append(this.donotpostalmail);
        b.append(", ");
        b.append("activitypartyid=");
        b.append(this.activitypartyid);
        b.append(", ");
        b.append("donotemail=");
        b.append(this.donotemail);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
