package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "UpdatedEntityData", 
    "DeletedEntityData"})
@JsonInclude(Include.NON_NULL)
public class SubscriptionData implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("UpdatedEntityData")
    protected List<SubscriptionUpdatedEntityData> updatedEntityData;

    @JsonProperty("UpdatedEntityData@nextLink")
    protected String updatedEntityDataNextLink;

    @JsonProperty("DeletedEntityData")
    protected List<SubscriptionDeletedEntityData> deletedEntityData;

    @JsonProperty("DeletedEntityData@nextLink")
    protected String deletedEntityDataNextLink;

    protected SubscriptionData() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SubscriptionData";
    }

    @Property(name="UpdatedEntityData")
    @JsonIgnore
    public CollectionPage<SubscriptionUpdatedEntityData> getUpdatedEntityData() {
        return new CollectionPage<SubscriptionUpdatedEntityData>(contextPath, SubscriptionUpdatedEntityData.class, this.updatedEntityData, Optional.ofNullable(updatedEntityDataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="UpdatedEntityData")
    @JsonIgnore
    public CollectionPage<SubscriptionUpdatedEntityData> getUpdatedEntityData(HttpRequestOptions options) {
        return new CollectionPage<SubscriptionUpdatedEntityData>(contextPath, SubscriptionUpdatedEntityData.class, this.updatedEntityData, Optional.ofNullable(updatedEntityDataNextLink), Collections.emptyList(), options);
    }

    @Property(name="DeletedEntityData")
    @JsonIgnore
    public CollectionPage<SubscriptionDeletedEntityData> getDeletedEntityData() {
        return new CollectionPage<SubscriptionDeletedEntityData>(contextPath, SubscriptionDeletedEntityData.class, this.deletedEntityData, Optional.ofNullable(deletedEntityDataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="DeletedEntityData")
    @JsonIgnore
    public CollectionPage<SubscriptionDeletedEntityData> getDeletedEntityData(HttpRequestOptions options) {
        return new CollectionPage<SubscriptionDeletedEntityData>(contextPath, SubscriptionDeletedEntityData.class, this.deletedEntityData, Optional.ofNullable(deletedEntityDataNextLink), Collections.emptyList(), options);
    }

    public SubscriptionData withUnmappedField(String name, String value) {
        SubscriptionData _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<SubscriptionUpdatedEntityData> updatedEntityData;
        private String updatedEntityDataNextLink;
        private List<SubscriptionDeletedEntityData> deletedEntityData;
        private String deletedEntityDataNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder updatedEntityData(List<SubscriptionUpdatedEntityData> updatedEntityData) {
            this.updatedEntityData = updatedEntityData;
            this.changedFields = changedFields.add("UpdatedEntityData");
            return this;
        }

        public Builder updatedEntityData(SubscriptionUpdatedEntityData... updatedEntityData) {
            return updatedEntityData(Arrays.asList(updatedEntityData));
        }

        public Builder updatedEntityDataNextLink(String updatedEntityDataNextLink) {
            this.updatedEntityDataNextLink = updatedEntityDataNextLink;
            this.changedFields = changedFields.add("UpdatedEntityData");
            return this;
        }

        public Builder deletedEntityData(List<SubscriptionDeletedEntityData> deletedEntityData) {
            this.deletedEntityData = deletedEntityData;
            this.changedFields = changedFields.add("DeletedEntityData");
            return this;
        }

        public Builder deletedEntityData(SubscriptionDeletedEntityData... deletedEntityData) {
            return deletedEntityData(Arrays.asList(deletedEntityData));
        }

        public Builder deletedEntityDataNextLink(String deletedEntityDataNextLink) {
            this.deletedEntityDataNextLink = deletedEntityDataNextLink;
            this.changedFields = changedFields.add("DeletedEntityData");
            return this;
        }

        public SubscriptionData build() {
            SubscriptionData _x = new SubscriptionData();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SubscriptionData";
            _x.updatedEntityData = updatedEntityData;
            _x.updatedEntityDataNextLink = updatedEntityDataNextLink;
            _x.deletedEntityData = deletedEntityData;
            _x.deletedEntityDataNextLink = deletedEntityDataNextLink;
            return _x;
        }
    }

    private SubscriptionData _copy() {
        SubscriptionData _x = new SubscriptionData();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.updatedEntityData = updatedEntityData;
        _x.deletedEntityData = deletedEntityData;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SubscriptionData[");
        b.append("UpdatedEntityData=");
        b.append(this.updatedEntityData);
        b.append(", ");
        b.append("DeletedEntityData=");
        b.append(this.deletedEntityData);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
