package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.PrivilegeDepth;

@JsonPropertyOrder({
    "@odata.type", 
    "Depth", 
    "PrivilegeId", 
    "BusinessUnitId"})
@JsonInclude(Include.NON_NULL)
public class RolePrivilege implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Depth")
    protected PrivilegeDepth depth;

    @JsonProperty("PrivilegeId")
    protected String privilegeId;

    @JsonProperty("BusinessUnitId")
    protected String businessUnitId;

    protected RolePrivilege() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RolePrivilege";
    }

    @Property(name="Depth")
    @JsonIgnore
    public Optional<PrivilegeDepth> getDepth() {
        return Optional.ofNullable(depth);
    }

    public RolePrivilege withDepth(PrivilegeDepth depth) {
        RolePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RolePrivilege");
        _x.depth = depth;
        return _x;
    }

    @Property(name="PrivilegeId")
    @JsonIgnore
    public Optional<String> getPrivilegeId() {
        return Optional.ofNullable(privilegeId);
    }

    public RolePrivilege withPrivilegeId(String privilegeId) {
        RolePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RolePrivilege");
        _x.privilegeId = privilegeId;
        return _x;
    }

    @Property(name="BusinessUnitId")
    @JsonIgnore
    public Optional<String> getBusinessUnitId() {
        return Optional.ofNullable(businessUnitId);
    }

    public RolePrivilege withBusinessUnitId(String businessUnitId) {
        RolePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RolePrivilege");
        _x.businessUnitId = businessUnitId;
        return _x;
    }

    public RolePrivilege withUnmappedField(String name, String value) {
        RolePrivilege _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PrivilegeDepth depth;
        private String privilegeId;
        private String businessUnitId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder depth(PrivilegeDepth depth) {
            this.depth = depth;
            this.changedFields = changedFields.add("Depth");
            return this;
        }

        public Builder privilegeId(String privilegeId) {
            this.privilegeId = privilegeId;
            this.changedFields = changedFields.add("PrivilegeId");
            return this;
        }

        public Builder businessUnitId(String businessUnitId) {
            this.businessUnitId = businessUnitId;
            this.changedFields = changedFields.add("BusinessUnitId");
            return this;
        }

        public RolePrivilege build() {
            RolePrivilege _x = new RolePrivilege();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RolePrivilege";
            _x.depth = depth;
            _x.privilegeId = privilegeId;
            _x.businessUnitId = businessUnitId;
            return _x;
        }
    }

    private RolePrivilege _copy() {
        RolePrivilege _x = new RolePrivilege();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.depth = depth;
        _x.privilegeId = privilegeId;
        _x.businessUnitId = businessUnitId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RolePrivilege[");
        b.append("Depth=");
        b.append(this.depth);
        b.append(", ");
        b.append("PrivilegeId=");
        b.append(this.privilegeId);
        b.append(", ");
        b.append("BusinessUnitId=");
        b.append(this.businessUnitId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
