package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AppSettingDetailCollection"})
@JsonInclude(Include.NON_NULL)
public class RetrieveAppSettingListResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AppSettingDetailCollection")
    protected List<AppSettingDetail> appSettingDetailCollection;

    @JsonProperty("AppSettingDetailCollection@nextLink")
    protected String appSettingDetailCollectionNextLink;

    protected RetrieveAppSettingListResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveAppSettingListResponse";
    }

    @Property(name="AppSettingDetailCollection")
    @JsonIgnore
    public CollectionPage<AppSettingDetail> getAppSettingDetailCollection() {
        return new CollectionPage<AppSettingDetail>(contextPath, AppSettingDetail.class, this.appSettingDetailCollection, Optional.ofNullable(appSettingDetailCollectionNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AppSettingDetailCollection")
    @JsonIgnore
    public CollectionPage<AppSettingDetail> getAppSettingDetailCollection(HttpRequestOptions options) {
        return new CollectionPage<AppSettingDetail>(contextPath, AppSettingDetail.class, this.appSettingDetailCollection, Optional.ofNullable(appSettingDetailCollectionNextLink), Collections.emptyList(), options);
    }

    public RetrieveAppSettingListResponse withUnmappedField(String name, String value) {
        RetrieveAppSettingListResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AppSettingDetail> appSettingDetailCollection;
        private String appSettingDetailCollectionNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appSettingDetailCollection(List<AppSettingDetail> appSettingDetailCollection) {
            this.appSettingDetailCollection = appSettingDetailCollection;
            this.changedFields = changedFields.add("AppSettingDetailCollection");
            return this;
        }

        public Builder appSettingDetailCollection(AppSettingDetail... appSettingDetailCollection) {
            return appSettingDetailCollection(Arrays.asList(appSettingDetailCollection));
        }

        public Builder appSettingDetailCollectionNextLink(String appSettingDetailCollectionNextLink) {
            this.appSettingDetailCollectionNextLink = appSettingDetailCollectionNextLink;
            this.changedFields = changedFields.add("AppSettingDetailCollection");
            return this;
        }

        public RetrieveAppSettingListResponse build() {
            RetrieveAppSettingListResponse _x = new RetrieveAppSettingListResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveAppSettingListResponse";
            _x.appSettingDetailCollection = appSettingDetailCollection;
            _x.appSettingDetailCollectionNextLink = appSettingDetailCollectionNextLink;
            return _x;
        }
    }

    private RetrieveAppSettingListResponse _copy() {
        RetrieveAppSettingListResponse _x = new RetrieveAppSettingListResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appSettingDetailCollection = appSettingDetailCollection;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveAppSettingListResponse[");
        b.append("AppSettingDetailCollection=");
        b.append(this.appSettingDetailCollection);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
