package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.DeletedMetadataFilters;

@JsonPropertyOrder({
    "@odata.type", 
    "Count", 
    "IsReadOnly", 
    "Keys", 
    "Values"})
@JsonInclude(Include.NON_NULL)
public class DeletedMetadataCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Count")
    protected Integer count;

    @JsonProperty("IsReadOnly")
    protected Boolean isReadOnly;

    @JsonProperty("Keys")
    protected List<DeletedMetadataFilters> keys;

    @JsonProperty("Keys@nextLink")
    protected String keysNextLink;

    @JsonProperty("Values")
    protected List<GuidCollection> values;

    @JsonProperty("Values@nextLink")
    protected String valuesNextLink;

    protected DeletedMetadataCollection() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DeletedMetadataCollection";
    }

    @Property(name="Count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public DeletedMetadataCollection withCount(Integer count) {
        DeletedMetadataCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DeletedMetadataCollection");
        _x.count = count;
        return _x;
    }

    @Property(name="IsReadOnly")
    @JsonIgnore
    public Optional<Boolean> getIsReadOnly() {
        return Optional.ofNullable(isReadOnly);
    }

    public DeletedMetadataCollection withIsReadOnly(Boolean isReadOnly) {
        DeletedMetadataCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DeletedMetadataCollection");
        _x.isReadOnly = isReadOnly;
        return _x;
    }

    @Property(name="Keys")
    @JsonIgnore
    public CollectionPage<DeletedMetadataFilters> getKeys() {
        return new CollectionPage<DeletedMetadataFilters>(contextPath, DeletedMetadataFilters.class, this.keys, Optional.ofNullable(keysNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Keys")
    @JsonIgnore
    public CollectionPage<DeletedMetadataFilters> getKeys(HttpRequestOptions options) {
        return new CollectionPage<DeletedMetadataFilters>(contextPath, DeletedMetadataFilters.class, this.keys, Optional.ofNullable(keysNextLink), Collections.emptyList(), options);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<GuidCollection> getValues() {
        return new CollectionPage<GuidCollection>(contextPath, GuidCollection.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<GuidCollection> getValues(HttpRequestOptions options) {
        return new CollectionPage<GuidCollection>(contextPath, GuidCollection.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), options);
    }

    public DeletedMetadataCollection withUnmappedField(String name, String value) {
        DeletedMetadataCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer count;
        private Boolean isReadOnly;
        private List<DeletedMetadataFilters> keys;
        private String keysNextLink;
        private List<GuidCollection> values;
        private String valuesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("Count");
            return this;
        }

        public Builder isReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            this.changedFields = changedFields.add("IsReadOnly");
            return this;
        }

        public Builder keys(List<DeletedMetadataFilters> keys) {
            this.keys = keys;
            this.changedFields = changedFields.add("Keys");
            return this;
        }

        public Builder keys(DeletedMetadataFilters... keys) {
            return keys(Arrays.asList(keys));
        }

        public Builder keysNextLink(String keysNextLink) {
            this.keysNextLink = keysNextLink;
            this.changedFields = changedFields.add("Keys");
            return this;
        }

        public Builder values(List<GuidCollection> values) {
            this.values = values;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public Builder values(GuidCollection... values) {
            return values(Arrays.asList(values));
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public DeletedMetadataCollection build() {
            DeletedMetadataCollection _x = new DeletedMetadataCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DeletedMetadataCollection";
            _x.count = count;
            _x.isReadOnly = isReadOnly;
            _x.keys = keys;
            _x.keysNextLink = keysNextLink;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            return _x;
        }
    }

    private DeletedMetadataCollection _copy() {
        DeletedMetadataCollection _x = new DeletedMetadataCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.count = count;
        _x.isReadOnly = isReadOnly;
        _x.keys = keys;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeletedMetadataCollection[");
        b.append("Count=");
        b.append(this.count);
        b.append(", ");
        b.append("IsReadOnly=");
        b.append(this.isReadOnly);
        b.append(", ");
        b.append("Keys=");
        b.append(this.keys);
        b.append(", ");
        b.append("Values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
