/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.entity.MetadataBase;
import microsoft.dynamics.crm.enums.ManagedPropertyEvaluationPriority;
import microsoft.dynamics.crm.enums.ManagedPropertyOperation;
import microsoft.dynamics.crm.enums.ManagedPropertyType;

@JsonPropertyOrder(value={"@odata.type", "LogicalName", "DisplayName", "ManagedPropertyType", "Operation", "IsGlobalForOperation", "EvaluationPriority", "IsPrivate", "ErrorCode", "EnablesEntityName", "EnablesAttributeName", "Description", "IntroducedVersion"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ManagedPropertyMetadata
extends MetadataBase
implements ODataEntityType {
    @JsonProperty(value="LogicalName")
    protected String logicalName;
    @JsonProperty(value="DisplayName")
    protected Label displayName;
    @JsonProperty(value="ManagedPropertyType")
    protected ManagedPropertyType managedPropertyType;
    @JsonProperty(value="Operation")
    protected ManagedPropertyOperation operation;
    @JsonProperty(value="IsGlobalForOperation")
    protected Boolean isGlobalForOperation;
    @JsonProperty(value="EvaluationPriority")
    protected ManagedPropertyEvaluationPriority evaluationPriority;
    @JsonProperty(value="IsPrivate")
    protected Boolean isPrivate;
    @JsonProperty(value="ErrorCode")
    protected Integer errorCode;
    @JsonProperty(value="EnablesEntityName")
    protected String enablesEntityName;
    @JsonProperty(value="EnablesAttributeName")
    protected String enablesAttributeName;
    @JsonProperty(value="Description")
    protected Label description;
    @JsonProperty(value="IntroducedVersion")
    protected String introducedVersion;

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ManagedPropertyMetadata";
    }

    protected ManagedPropertyMetadata() {
    }

    public static Builder builderManagedPropertyMetadata() {
        return new Builder();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return this.changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && this.metadataId != null) {
            this.contextPath = this.contextPath.clearQueries().addKeys(new NameValue[]{new NameValue(this.metadataId.toString())});
        }
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(this.logicalName);
    }

    public ManagedPropertyMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii((String)logicalName);
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("LogicalName");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public ManagedPropertyMetadata withDisplayName(Label displayName) {
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("DisplayName");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="ManagedPropertyType")
    @JsonIgnore
    public Optional<ManagedPropertyType> getManagedPropertyType() {
        return Optional.ofNullable(this.managedPropertyType);
    }

    public ManagedPropertyMetadata withManagedPropertyType(ManagedPropertyType managedPropertyType) {
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("ManagedPropertyType");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.managedPropertyType = managedPropertyType;
        return _x;
    }

    @Property(name="Operation")
    @JsonIgnore
    public Optional<ManagedPropertyOperation> getOperation() {
        return Optional.ofNullable(this.operation);
    }

    public ManagedPropertyMetadata withOperation(ManagedPropertyOperation operation) {
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("Operation");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.operation = operation;
        return _x;
    }

    @Property(name="IsGlobalForOperation")
    @JsonIgnore
    public Optional<Boolean> getIsGlobalForOperation() {
        return Optional.ofNullable(this.isGlobalForOperation);
    }

    public ManagedPropertyMetadata withIsGlobalForOperation(Boolean isGlobalForOperation) {
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("IsGlobalForOperation");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.isGlobalForOperation = isGlobalForOperation;
        return _x;
    }

    @Property(name="EvaluationPriority")
    @JsonIgnore
    public Optional<ManagedPropertyEvaluationPriority> getEvaluationPriority() {
        return Optional.ofNullable(this.evaluationPriority);
    }

    public ManagedPropertyMetadata withEvaluationPriority(ManagedPropertyEvaluationPriority evaluationPriority) {
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("EvaluationPriority");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.evaluationPriority = evaluationPriority;
        return _x;
    }

    @Property(name="IsPrivate")
    @JsonIgnore
    public Optional<Boolean> getIsPrivate() {
        return Optional.ofNullable(this.isPrivate);
    }

    public ManagedPropertyMetadata withIsPrivate(Boolean isPrivate) {
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("IsPrivate");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.isPrivate = isPrivate;
        return _x;
    }

    @Property(name="ErrorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(this.errorCode);
    }

    public ManagedPropertyMetadata withErrorCode(Integer errorCode) {
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("ErrorCode");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.errorCode = errorCode;
        return _x;
    }

    @Property(name="EnablesEntityName")
    @JsonIgnore
    public Optional<String> getEnablesEntityName() {
        return Optional.ofNullable(this.enablesEntityName);
    }

    public ManagedPropertyMetadata withEnablesEntityName(String enablesEntityName) {
        Checks.checkIsAscii((String)enablesEntityName);
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("EnablesEntityName");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.enablesEntityName = enablesEntityName;
        return _x;
    }

    @Property(name="EnablesAttributeName")
    @JsonIgnore
    public Optional<String> getEnablesAttributeName() {
        return Optional.ofNullable(this.enablesAttributeName);
    }

    public ManagedPropertyMetadata withEnablesAttributeName(String enablesAttributeName) {
        Checks.checkIsAscii((String)enablesAttributeName);
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("EnablesAttributeName");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.enablesAttributeName = enablesAttributeName;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public ManagedPropertyMetadata withDescription(Label description) {
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("Description");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(this.introducedVersion);
    }

    public ManagedPropertyMetadata withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii((String)introducedVersion);
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("IntroducedVersion");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ManagedPropertyMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Override
    public ManagedPropertyMetadata withUnmappedField(String name, String value) {
        ManagedPropertyMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    @Override
    public ManagedPropertyMetadata patch() {
        RequestHelper.patch((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    @Override
    public ManagedPropertyMetadata put() {
        RequestHelper.put((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        ManagedPropertyMetadata _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedPropertyMetadata _copy() {
        ManagedPropertyMetadata _x = new ManagedPropertyMetadata();
        _x.contextPath = this.contextPath;
        _x.changedFields = this.changedFields;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.metadataId = this.metadataId;
        _x.hasChanged = this.hasChanged;
        _x.logicalName = this.logicalName;
        _x.displayName = this.displayName;
        _x.managedPropertyType = this.managedPropertyType;
        _x.operation = this.operation;
        _x.isGlobalForOperation = this.isGlobalForOperation;
        _x.evaluationPriority = this.evaluationPriority;
        _x.isPrivate = this.isPrivate;
        _x.errorCode = this.errorCode;
        _x.enablesEntityName = this.enablesEntityName;
        _x.enablesAttributeName = this.enablesAttributeName;
        _x.description = this.description;
        _x.introducedVersion = this.introducedVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedPropertyMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("ManagedPropertyType=");
        b.append((Object)this.managedPropertyType);
        b.append(", ");
        b.append("Operation=");
        b.append((Object)this.operation);
        b.append(", ");
        b.append("IsGlobalForOperation=");
        b.append(this.isGlobalForOperation);
        b.append(", ");
        b.append("EvaluationPriority=");
        b.append((Object)this.evaluationPriority);
        b.append(", ");
        b.append("IsPrivate=");
        b.append(this.isPrivate);
        b.append(", ");
        b.append("ErrorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("EnablesEntityName=");
        b.append(this.enablesEntityName);
        b.append(", ");
        b.append("EnablesAttributeName=");
        b.append(this.enablesAttributeName);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String metadataId;
        private Boolean hasChanged;
        private String logicalName;
        private Label displayName;
        private ManagedPropertyType managedPropertyType;
        private ManagedPropertyOperation operation;
        private Boolean isGlobalForOperation;
        private ManagedPropertyEvaluationPriority evaluationPriority;
        private Boolean isPrivate;
        private Integer errorCode;
        private String enablesEntityName;
        private String enablesAttributeName;
        private Label description;
        private String introducedVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = this.changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = this.changedFields.add("HasChanged");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = this.changedFields.add("LogicalName");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder managedPropertyType(ManagedPropertyType managedPropertyType) {
            this.managedPropertyType = managedPropertyType;
            this.changedFields = this.changedFields.add("ManagedPropertyType");
            return this;
        }

        public Builder operation(ManagedPropertyOperation operation) {
            this.operation = operation;
            this.changedFields = this.changedFields.add("Operation");
            return this;
        }

        public Builder isGlobalForOperation(Boolean isGlobalForOperation) {
            this.isGlobalForOperation = isGlobalForOperation;
            this.changedFields = this.changedFields.add("IsGlobalForOperation");
            return this;
        }

        public Builder evaluationPriority(ManagedPropertyEvaluationPriority evaluationPriority) {
            this.evaluationPriority = evaluationPriority;
            this.changedFields = this.changedFields.add("EvaluationPriority");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.changedFields = this.changedFields.add("IsPrivate");
            return this;
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = this.changedFields.add("ErrorCode");
            return this;
        }

        public Builder enablesEntityName(String enablesEntityName) {
            this.enablesEntityName = enablesEntityName;
            this.changedFields = this.changedFields.add("EnablesEntityName");
            return this;
        }

        public Builder enablesAttributeName(String enablesAttributeName) {
            this.enablesAttributeName = enablesAttributeName;
            this.changedFields = this.changedFields.add("EnablesAttributeName");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = this.changedFields.add("Description");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = this.changedFields.add("IntroducedVersion");
            return this;
        }

        public ManagedPropertyMetadata build() {
            ManagedPropertyMetadata _x = new ManagedPropertyMetadata();
            _x.contextPath = null;
            _x.changedFields = this.changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ManagedPropertyMetadata";
            _x.metadataId = this.metadataId;
            _x.hasChanged = this.hasChanged;
            _x.logicalName = this.logicalName;
            _x.displayName = this.displayName;
            _x.managedPropertyType = this.managedPropertyType;
            _x.operation = this.operation;
            _x.isGlobalForOperation = this.isGlobalForOperation;
            _x.evaluationPriority = this.evaluationPriority;
            _x.isPrivate = this.isPrivate;
            _x.errorCode = this.errorCode;
            _x.enablesEntityName = this.enablesEntityName;
            _x.enablesAttributeName = this.enablesAttributeName;
            _x.description = this.description;
            _x.introducedVersion = this.introducedVersion;
            return _x;
        }
    }
}

