/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.time.OffsetDateTime;
import java.util.Optional;
import microsoft.dynamics.crm.complex.AttributeRequiredLevelManagedProperty;
import microsoft.dynamics.crm.complex.AttributeTypeDisplayName;
import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.entity.AttributeMetadata;
import microsoft.dynamics.crm.enums.AttributeTypeCode;
import microsoft.dynamics.crm.enums.IntegerFormat;

@JsonPropertyOrder(value={"@odata.type", "Format", "MaxValue", "MinValue", "FormulaDefinition", "SourceTypeMask"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IntegerAttributeMetadata
extends AttributeMetadata
implements ODataEntityType {
    @JsonProperty(value="Format")
    protected IntegerFormat format;
    @JsonProperty(value="MaxValue")
    protected Integer maxValue;
    @JsonProperty(value="MinValue")
    protected Integer minValue;
    @JsonProperty(value="FormulaDefinition")
    protected String formulaDefinition;
    @JsonProperty(value="SourceTypeMask")
    protected Integer sourceTypeMask;

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.IntegerAttributeMetadata";
    }

    protected IntegerAttributeMetadata() {
    }

    public static Builder builderIntegerAttributeMetadata() {
        return new Builder();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return this.changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && this.metadataId != null) {
            this.contextPath = this.contextPath.clearQueries().addKeys(new NameValue[]{new NameValue(this.metadataId.toString())});
        }
    }

    @Property(name="Format")
    @JsonIgnore
    public Optional<IntegerFormat> getFormat() {
        return Optional.ofNullable(this.format);
    }

    public IntegerAttributeMetadata withFormat(IntegerFormat format) {
        IntegerAttributeMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("Format");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.IntegerAttributeMetadata");
        _x.format = format;
        return _x;
    }

    @Property(name="MaxValue")
    @JsonIgnore
    public Optional<Integer> getMaxValue() {
        return Optional.ofNullable(this.maxValue);
    }

    public IntegerAttributeMetadata withMaxValue(Integer maxValue) {
        IntegerAttributeMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("MaxValue");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.IntegerAttributeMetadata");
        _x.maxValue = maxValue;
        return _x;
    }

    @Property(name="MinValue")
    @JsonIgnore
    public Optional<Integer> getMinValue() {
        return Optional.ofNullable(this.minValue);
    }

    public IntegerAttributeMetadata withMinValue(Integer minValue) {
        IntegerAttributeMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("MinValue");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.IntegerAttributeMetadata");
        _x.minValue = minValue;
        return _x;
    }

    @Property(name="FormulaDefinition")
    @JsonIgnore
    public Optional<String> getFormulaDefinition() {
        return Optional.ofNullable(this.formulaDefinition);
    }

    public IntegerAttributeMetadata withFormulaDefinition(String formulaDefinition) {
        Checks.checkIsAscii((String)formulaDefinition);
        IntegerAttributeMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("FormulaDefinition");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.IntegerAttributeMetadata");
        _x.formulaDefinition = formulaDefinition;
        return _x;
    }

    @Property(name="SourceTypeMask")
    @JsonIgnore
    public Optional<Integer> getSourceTypeMask() {
        return Optional.ofNullable(this.sourceTypeMask);
    }

    public IntegerAttributeMetadata withSourceTypeMask(Integer sourceTypeMask) {
        IntegerAttributeMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("SourceTypeMask");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.IntegerAttributeMetadata");
        _x.sourceTypeMask = sourceTypeMask;
        return _x;
    }

    @Override
    public IntegerAttributeMetadata withUnmappedField(String name, String value) {
        IntegerAttributeMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    @Override
    public IntegerAttributeMetadata patch() {
        RequestHelper.patch((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        IntegerAttributeMetadata _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    @Override
    public IntegerAttributeMetadata put() {
        RequestHelper.put((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        IntegerAttributeMetadata _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    private IntegerAttributeMetadata _copy() {
        IntegerAttributeMetadata _x = new IntegerAttributeMetadata();
        _x.contextPath = this.contextPath;
        _x.changedFields = this.changedFields;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.metadataId = this.metadataId;
        _x.hasChanged = this.hasChanged;
        _x.attributeOf = this.attributeOf;
        _x.attributeType = this.attributeType;
        _x.attributeTypeName = this.attributeTypeName;
        _x.columnNumber = this.columnNumber;
        _x.description = this.description;
        _x.displayName = this.displayName;
        _x.deprecatedVersion = this.deprecatedVersion;
        _x.introducedVersion = this.introducedVersion;
        _x.entityLogicalName = this.entityLogicalName;
        _x.isAuditEnabled = this.isAuditEnabled;
        _x.isCustomAttribute = this.isCustomAttribute;
        _x.isPrimaryId = this.isPrimaryId;
        _x.isValidODataAttribute = this.isValidODataAttribute;
        _x.isPrimaryName = this.isPrimaryName;
        _x.isValidForCreate = this.isValidForCreate;
        _x.isValidForRead = this.isValidForRead;
        _x.isValidForUpdate = this.isValidForUpdate;
        _x.canBeSecuredForRead = this.canBeSecuredForRead;
        _x.canBeSecuredForCreate = this.canBeSecuredForCreate;
        _x.canBeSecuredForUpdate = this.canBeSecuredForUpdate;
        _x.isSecured = this.isSecured;
        _x.isRetrievable = this.isRetrievable;
        _x.isFilterable = this.isFilterable;
        _x.isSearchable = this.isSearchable;
        _x.isManaged = this.isManaged;
        _x.isGlobalFilterEnabled = this.isGlobalFilterEnabled;
        _x.isSortableEnabled = this.isSortableEnabled;
        _x.linkedAttributeId = this.linkedAttributeId;
        _x.logicalName = this.logicalName;
        _x.isCustomizable = this.isCustomizable;
        _x.isRenameable = this.isRenameable;
        _x.isValidForAdvancedFind = this.isValidForAdvancedFind;
        _x.isValidForForm = this.isValidForForm;
        _x.isRequiredForForm = this.isRequiredForForm;
        _x.isValidForGrid = this.isValidForGrid;
        _x.requiredLevel = this.requiredLevel;
        _x.canModifyAdditionalSettings = this.canModifyAdditionalSettings;
        _x.schemaName = this.schemaName;
        _x.externalName = this.externalName;
        _x.isLogical = this.isLogical;
        _x.isDataSourceSecret = this.isDataSourceSecret;
        _x.inheritsFrom = this.inheritsFrom;
        _x.createdOn = this.createdOn;
        _x.modifiedOn = this.modifiedOn;
        _x.sourceType = this.sourceType;
        _x.autoNumberFormat = this.autoNumberFormat;
        _x.format = this.format;
        _x.maxValue = this.maxValue;
        _x.minValue = this.minValue;
        _x.formulaDefinition = this.formulaDefinition;
        _x.sourceTypeMask = this.sourceTypeMask;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IntegerAttributeMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("AttributeOf=");
        b.append(this.attributeOf);
        b.append(", ");
        b.append("AttributeType=");
        b.append((Object)this.attributeType);
        b.append(", ");
        b.append("AttributeTypeName=");
        b.append(this.attributeTypeName);
        b.append(", ");
        b.append("ColumnNumber=");
        b.append(this.columnNumber);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("DeprecatedVersion=");
        b.append(this.deprecatedVersion);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("IsAuditEnabled=");
        b.append(this.isAuditEnabled);
        b.append(", ");
        b.append("IsCustomAttribute=");
        b.append(this.isCustomAttribute);
        b.append(", ");
        b.append("IsPrimaryId=");
        b.append(this.isPrimaryId);
        b.append(", ");
        b.append("IsValidODataAttribute=");
        b.append(this.isValidODataAttribute);
        b.append(", ");
        b.append("IsPrimaryName=");
        b.append(this.isPrimaryName);
        b.append(", ");
        b.append("IsValidForCreate=");
        b.append(this.isValidForCreate);
        b.append(", ");
        b.append("IsValidForRead=");
        b.append(this.isValidForRead);
        b.append(", ");
        b.append("IsValidForUpdate=");
        b.append(this.isValidForUpdate);
        b.append(", ");
        b.append("CanBeSecuredForRead=");
        b.append(this.canBeSecuredForRead);
        b.append(", ");
        b.append("CanBeSecuredForCreate=");
        b.append(this.canBeSecuredForCreate);
        b.append(", ");
        b.append("CanBeSecuredForUpdate=");
        b.append(this.canBeSecuredForUpdate);
        b.append(", ");
        b.append("IsSecured=");
        b.append(this.isSecured);
        b.append(", ");
        b.append("IsRetrievable=");
        b.append(this.isRetrievable);
        b.append(", ");
        b.append("IsFilterable=");
        b.append(this.isFilterable);
        b.append(", ");
        b.append("IsSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsGlobalFilterEnabled=");
        b.append(this.isGlobalFilterEnabled);
        b.append(", ");
        b.append("IsSortableEnabled=");
        b.append(this.isSortableEnabled);
        b.append(", ");
        b.append("LinkedAttributeId=");
        b.append(this.linkedAttributeId);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsRenameable=");
        b.append(this.isRenameable);
        b.append(", ");
        b.append("IsValidForAdvancedFind=");
        b.append(this.isValidForAdvancedFind);
        b.append(", ");
        b.append("IsValidForForm=");
        b.append(this.isValidForForm);
        b.append(", ");
        b.append("IsRequiredForForm=");
        b.append(this.isRequiredForForm);
        b.append(", ");
        b.append("IsValidForGrid=");
        b.append(this.isValidForGrid);
        b.append(", ");
        b.append("RequiredLevel=");
        b.append(this.requiredLevel);
        b.append(", ");
        b.append("CanModifyAdditionalSettings=");
        b.append(this.canModifyAdditionalSettings);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("ExternalName=");
        b.append(this.externalName);
        b.append(", ");
        b.append("IsLogical=");
        b.append(this.isLogical);
        b.append(", ");
        b.append("IsDataSourceSecret=");
        b.append(this.isDataSourceSecret);
        b.append(", ");
        b.append("InheritsFrom=");
        b.append(this.inheritsFrom);
        b.append(", ");
        b.append("CreatedOn=");
        b.append(this.createdOn);
        b.append(", ");
        b.append("ModifiedOn=");
        b.append(this.modifiedOn);
        b.append(", ");
        b.append("SourceType=");
        b.append(this.sourceType);
        b.append(", ");
        b.append("AutoNumberFormat=");
        b.append(this.autoNumberFormat);
        b.append(", ");
        b.append("Format=");
        b.append((Object)this.format);
        b.append(", ");
        b.append("MaxValue=");
        b.append(this.maxValue);
        b.append(", ");
        b.append("MinValue=");
        b.append(this.minValue);
        b.append(", ");
        b.append("FormulaDefinition=");
        b.append(this.formulaDefinition);
        b.append(", ");
        b.append("SourceTypeMask=");
        b.append(this.sourceTypeMask);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String metadataId;
        private Boolean hasChanged;
        private String attributeOf;
        private AttributeTypeCode attributeType;
        private AttributeTypeDisplayName attributeTypeName;
        private Integer columnNumber;
        private Label description;
        private Label displayName;
        private String deprecatedVersion;
        private String introducedVersion;
        private String entityLogicalName;
        private BooleanManagedProperty isAuditEnabled;
        private Boolean isCustomAttribute;
        private Boolean isPrimaryId;
        private Boolean isValidODataAttribute;
        private Boolean isPrimaryName;
        private Boolean isValidForCreate;
        private Boolean isValidForRead;
        private Boolean isValidForUpdate;
        private Boolean canBeSecuredForRead;
        private Boolean canBeSecuredForCreate;
        private Boolean canBeSecuredForUpdate;
        private Boolean isSecured;
        private Boolean isRetrievable;
        private Boolean isFilterable;
        private Boolean isSearchable;
        private Boolean isManaged;
        private BooleanManagedProperty isGlobalFilterEnabled;
        private BooleanManagedProperty isSortableEnabled;
        private String linkedAttributeId;
        private String logicalName;
        private BooleanManagedProperty isCustomizable;
        private BooleanManagedProperty isRenameable;
        private BooleanManagedProperty isValidForAdvancedFind;
        private Boolean isValidForForm;
        private Boolean isRequiredForForm;
        private Boolean isValidForGrid;
        private AttributeRequiredLevelManagedProperty requiredLevel;
        private BooleanManagedProperty canModifyAdditionalSettings;
        private String schemaName;
        private String externalName;
        private Boolean isLogical;
        private Boolean isDataSourceSecret;
        private String inheritsFrom;
        private OffsetDateTime createdOn;
        private OffsetDateTime modifiedOn;
        private Integer sourceType;
        private String autoNumberFormat;
        private IntegerFormat format;
        private Integer maxValue;
        private Integer minValue;
        private String formulaDefinition;
        private Integer sourceTypeMask;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = this.changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = this.changedFields.add("HasChanged");
            return this;
        }

        public Builder attributeOf(String attributeOf) {
            this.attributeOf = attributeOf;
            this.changedFields = this.changedFields.add("AttributeOf");
            return this;
        }

        public Builder attributeType(AttributeTypeCode attributeType) {
            this.attributeType = attributeType;
            this.changedFields = this.changedFields.add("AttributeType");
            return this;
        }

        public Builder attributeTypeName(AttributeTypeDisplayName attributeTypeName) {
            this.attributeTypeName = attributeTypeName;
            this.changedFields = this.changedFields.add("AttributeTypeName");
            return this;
        }

        public Builder columnNumber(Integer columnNumber) {
            this.columnNumber = columnNumber;
            this.changedFields = this.changedFields.add("ColumnNumber");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = this.changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder deprecatedVersion(String deprecatedVersion) {
            this.deprecatedVersion = deprecatedVersion;
            this.changedFields = this.changedFields.add("DeprecatedVersion");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = this.changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = this.changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder isAuditEnabled(BooleanManagedProperty isAuditEnabled) {
            this.isAuditEnabled = isAuditEnabled;
            this.changedFields = this.changedFields.add("IsAuditEnabled");
            return this;
        }

        public Builder isCustomAttribute(Boolean isCustomAttribute) {
            this.isCustomAttribute = isCustomAttribute;
            this.changedFields = this.changedFields.add("IsCustomAttribute");
            return this;
        }

        public Builder isPrimaryId(Boolean isPrimaryId) {
            this.isPrimaryId = isPrimaryId;
            this.changedFields = this.changedFields.add("IsPrimaryId");
            return this;
        }

        public Builder isValidODataAttribute(Boolean isValidODataAttribute) {
            this.isValidODataAttribute = isValidODataAttribute;
            this.changedFields = this.changedFields.add("IsValidODataAttribute");
            return this;
        }

        public Builder isPrimaryName(Boolean isPrimaryName) {
            this.isPrimaryName = isPrimaryName;
            this.changedFields = this.changedFields.add("IsPrimaryName");
            return this;
        }

        public Builder isValidForCreate(Boolean isValidForCreate) {
            this.isValidForCreate = isValidForCreate;
            this.changedFields = this.changedFields.add("IsValidForCreate");
            return this;
        }

        public Builder isValidForRead(Boolean isValidForRead) {
            this.isValidForRead = isValidForRead;
            this.changedFields = this.changedFields.add("IsValidForRead");
            return this;
        }

        public Builder isValidForUpdate(Boolean isValidForUpdate) {
            this.isValidForUpdate = isValidForUpdate;
            this.changedFields = this.changedFields.add("IsValidForUpdate");
            return this;
        }

        public Builder canBeSecuredForRead(Boolean canBeSecuredForRead) {
            this.canBeSecuredForRead = canBeSecuredForRead;
            this.changedFields = this.changedFields.add("CanBeSecuredForRead");
            return this;
        }

        public Builder canBeSecuredForCreate(Boolean canBeSecuredForCreate) {
            this.canBeSecuredForCreate = canBeSecuredForCreate;
            this.changedFields = this.changedFields.add("CanBeSecuredForCreate");
            return this;
        }

        public Builder canBeSecuredForUpdate(Boolean canBeSecuredForUpdate) {
            this.canBeSecuredForUpdate = canBeSecuredForUpdate;
            this.changedFields = this.changedFields.add("CanBeSecuredForUpdate");
            return this;
        }

        public Builder isSecured(Boolean isSecured) {
            this.isSecured = isSecured;
            this.changedFields = this.changedFields.add("IsSecured");
            return this;
        }

        public Builder isRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
            this.changedFields = this.changedFields.add("IsRetrievable");
            return this;
        }

        public Builder isFilterable(Boolean isFilterable) {
            this.isFilterable = isFilterable;
            this.changedFields = this.changedFields.add("IsFilterable");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = this.changedFields.add("IsSearchable");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = this.changedFields.add("IsManaged");
            return this;
        }

        public Builder isGlobalFilterEnabled(BooleanManagedProperty isGlobalFilterEnabled) {
            this.isGlobalFilterEnabled = isGlobalFilterEnabled;
            this.changedFields = this.changedFields.add("IsGlobalFilterEnabled");
            return this;
        }

        public Builder isSortableEnabled(BooleanManagedProperty isSortableEnabled) {
            this.isSortableEnabled = isSortableEnabled;
            this.changedFields = this.changedFields.add("IsSortableEnabled");
            return this;
        }

        public Builder linkedAttributeId(String linkedAttributeId) {
            this.linkedAttributeId = linkedAttributeId;
            this.changedFields = this.changedFields.add("LinkedAttributeId");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = this.changedFields.add("LogicalName");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = this.changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isRenameable(BooleanManagedProperty isRenameable) {
            this.isRenameable = isRenameable;
            this.changedFields = this.changedFields.add("IsRenameable");
            return this;
        }

        public Builder isValidForAdvancedFind(BooleanManagedProperty isValidForAdvancedFind) {
            this.isValidForAdvancedFind = isValidForAdvancedFind;
            this.changedFields = this.changedFields.add("IsValidForAdvancedFind");
            return this;
        }

        public Builder isValidForForm(Boolean isValidForForm) {
            this.isValidForForm = isValidForForm;
            this.changedFields = this.changedFields.add("IsValidForForm");
            return this;
        }

        public Builder isRequiredForForm(Boolean isRequiredForForm) {
            this.isRequiredForForm = isRequiredForForm;
            this.changedFields = this.changedFields.add("IsRequiredForForm");
            return this;
        }

        public Builder isValidForGrid(Boolean isValidForGrid) {
            this.isValidForGrid = isValidForGrid;
            this.changedFields = this.changedFields.add("IsValidForGrid");
            return this;
        }

        public Builder requiredLevel(AttributeRequiredLevelManagedProperty requiredLevel) {
            this.requiredLevel = requiredLevel;
            this.changedFields = this.changedFields.add("RequiredLevel");
            return this;
        }

        public Builder canModifyAdditionalSettings(BooleanManagedProperty canModifyAdditionalSettings) {
            this.canModifyAdditionalSettings = canModifyAdditionalSettings;
            this.changedFields = this.changedFields.add("CanModifyAdditionalSettings");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = this.changedFields.add("SchemaName");
            return this;
        }

        public Builder externalName(String externalName) {
            this.externalName = externalName;
            this.changedFields = this.changedFields.add("ExternalName");
            return this;
        }

        public Builder isLogical(Boolean isLogical) {
            this.isLogical = isLogical;
            this.changedFields = this.changedFields.add("IsLogical");
            return this;
        }

        public Builder isDataSourceSecret(Boolean isDataSourceSecret) {
            this.isDataSourceSecret = isDataSourceSecret;
            this.changedFields = this.changedFields.add("IsDataSourceSecret");
            return this;
        }

        public Builder inheritsFrom(String inheritsFrom) {
            this.inheritsFrom = inheritsFrom;
            this.changedFields = this.changedFields.add("InheritsFrom");
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            this.createdOn = createdOn;
            this.changedFields = this.changedFields.add("CreatedOn");
            return this;
        }

        public Builder modifiedOn(OffsetDateTime modifiedOn) {
            this.modifiedOn = modifiedOn;
            this.changedFields = this.changedFields.add("ModifiedOn");
            return this;
        }

        public Builder sourceType(Integer sourceType) {
            this.sourceType = sourceType;
            this.changedFields = this.changedFields.add("SourceType");
            return this;
        }

        public Builder autoNumberFormat(String autoNumberFormat) {
            this.autoNumberFormat = autoNumberFormat;
            this.changedFields = this.changedFields.add("AutoNumberFormat");
            return this;
        }

        public Builder format(IntegerFormat format) {
            this.format = format;
            this.changedFields = this.changedFields.add("Format");
            return this;
        }

        public Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            this.changedFields = this.changedFields.add("MaxValue");
            return this;
        }

        public Builder minValue(Integer minValue) {
            this.minValue = minValue;
            this.changedFields = this.changedFields.add("MinValue");
            return this;
        }

        public Builder formulaDefinition(String formulaDefinition) {
            this.formulaDefinition = formulaDefinition;
            this.changedFields = this.changedFields.add("FormulaDefinition");
            return this;
        }

        public Builder sourceTypeMask(Integer sourceTypeMask) {
            this.sourceTypeMask = sourceTypeMask;
            this.changedFields = this.changedFields.add("SourceTypeMask");
            return this;
        }

        public IntegerAttributeMetadata build() {
            IntegerAttributeMetadata _x = new IntegerAttributeMetadata();
            _x.contextPath = null;
            _x.changedFields = this.changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.IntegerAttributeMetadata";
            _x.metadataId = this.metadataId;
            _x.hasChanged = this.hasChanged;
            _x.attributeOf = this.attributeOf;
            _x.attributeType = this.attributeType;
            _x.attributeTypeName = this.attributeTypeName;
            _x.columnNumber = this.columnNumber;
            _x.description = this.description;
            _x.displayName = this.displayName;
            _x.deprecatedVersion = this.deprecatedVersion;
            _x.introducedVersion = this.introducedVersion;
            _x.entityLogicalName = this.entityLogicalName;
            _x.isAuditEnabled = this.isAuditEnabled;
            _x.isCustomAttribute = this.isCustomAttribute;
            _x.isPrimaryId = this.isPrimaryId;
            _x.isValidODataAttribute = this.isValidODataAttribute;
            _x.isPrimaryName = this.isPrimaryName;
            _x.isValidForCreate = this.isValidForCreate;
            _x.isValidForRead = this.isValidForRead;
            _x.isValidForUpdate = this.isValidForUpdate;
            _x.canBeSecuredForRead = this.canBeSecuredForRead;
            _x.canBeSecuredForCreate = this.canBeSecuredForCreate;
            _x.canBeSecuredForUpdate = this.canBeSecuredForUpdate;
            _x.isSecured = this.isSecured;
            _x.isRetrievable = this.isRetrievable;
            _x.isFilterable = this.isFilterable;
            _x.isSearchable = this.isSearchable;
            _x.isManaged = this.isManaged;
            _x.isGlobalFilterEnabled = this.isGlobalFilterEnabled;
            _x.isSortableEnabled = this.isSortableEnabled;
            _x.linkedAttributeId = this.linkedAttributeId;
            _x.logicalName = this.logicalName;
            _x.isCustomizable = this.isCustomizable;
            _x.isRenameable = this.isRenameable;
            _x.isValidForAdvancedFind = this.isValidForAdvancedFind;
            _x.isValidForForm = this.isValidForForm;
            _x.isRequiredForForm = this.isRequiredForForm;
            _x.isValidForGrid = this.isValidForGrid;
            _x.requiredLevel = this.requiredLevel;
            _x.canModifyAdditionalSettings = this.canModifyAdditionalSettings;
            _x.schemaName = this.schemaName;
            _x.externalName = this.externalName;
            _x.isLogical = this.isLogical;
            _x.isDataSourceSecret = this.isDataSourceSecret;
            _x.inheritsFrom = this.inheritsFrom;
            _x.createdOn = this.createdOn;
            _x.modifiedOn = this.modifiedOn;
            _x.sourceType = this.sourceType;
            _x.autoNumberFormat = this.autoNumberFormat;
            _x.format = this.format;
            _x.maxValue = this.maxValue;
            _x.minValue = this.minValue;
            _x.formulaDefinition = this.formulaDefinition;
            _x.sourceTypeMask = this.sourceTypeMask;
            return _x;
        }
    }
}

