package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrivilegeType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Create")
    CREATE("Create", "1"),

    @JsonProperty("Read")
    READ("Read", "2"),

    @JsonProperty("Write")
    WRITE("Write", "3"),

    @JsonProperty("Delete")
    DELETE("Delete", "4"),

    @JsonProperty("Assign")
    ASSIGN("Assign", "5"),

    @JsonProperty("Share")
    SHARE("Share", "6"),

    @JsonProperty("Append")
    APPEND("Append", "7"),

    @JsonProperty("AppendTo")
    APPEND_TO("AppendTo", "8");

    private final String name;
    private final String value;

    private PrivilegeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
