package microsoft.dynamics.crm.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.PrivilegeCollectionRequest;

public final class Privileges extends PrivilegeCollectionRequest {

    public Privileges(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Asyncoperations privilege_AsyncOperations() {
        return new Asyncoperations(contextPath.addSegment("Privilege_AsyncOperations"));
    }

    public Bulkdeletefailures privilege_BulkDeleteFailures() {
        return new Bulkdeletefailures(contextPath.addSegment("Privilege_BulkDeleteFailures"));
    }

    public Roles roleprivileges_association() {
        return new Roles(contextPath.addSegment("roleprivileges_association"));
    }

    public Roletemplates roletemplateprivileges_association() {
        return new Roletemplates(contextPath.addSegment("roletemplateprivileges_association"));
    }

    public Solutions solution_privilege() {
        return new Solutions(contextPath.addSegment("solution_privilege"));
    }
}
