package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Teamtemplate;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;

@JsonIgnoreType
public class TeamtemplateRequest extends EntityRequest<Teamtemplate> {

    public TeamtemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(Teamtemplate.class, contextPath, value, false);
    }

    public TeamCollectionRequest teamtemplate_Teams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("teamtemplate_Teams"), Optional.empty());
    }

    public TeamRequest teamtemplate_Teams(String ownerid) {
        return new TeamRequest(contextPath.addSegment("teamtemplate_Teams").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SyncerrorCollectionRequest teamTemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("TeamTemplate_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest teamTemplate_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("TeamTemplate_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
