package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Rollupfield;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class RollupfieldRequest extends EntityRequest<Rollupfield> {

    public RollupfieldRequest(ContextPath contextPath, Optional<Object> value) {
        super(Rollupfield.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public MetricRequest metricid() {
        return new MetricRequest(contextPath.addSegment("metricid"), Optional.empty());
    }

    public ProcesssessionCollectionRequest rollupfield_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("rollupfield_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest rollupfield_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("rollupfield_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest rollupfield_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("rollupfield_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest rollupfield_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("rollupfield_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest rollupField_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("RollupField_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest rollupField_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("RollupField_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
