package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Expiredprocess;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;

@JsonIgnoreType
public class ExpiredprocessRequest extends EntityRequest<Expiredprocess> {

    public ExpiredprocessRequest(ContextPath contextPath, Optional<Object> value) {
        super(Expiredprocess.class, contextPath, value, false);
    }

    public SyncerrorCollectionRequest expiredProcess_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ExpiredProcess_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest expiredProcess_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ExpiredProcess_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticleid() {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticleid"), Optional.empty());
    }

    public ProcesssessionCollectionRequest expiredProcess_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("ExpiredProcess_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest expiredProcess_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("ExpiredProcess_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SystemuserRequest createdbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdbyname"), Optional.empty());
    }

    public WorkflowlogCollectionRequest workflowlogs_expiredprocess() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("workflowlogs_expiredprocess"), Optional.empty());
    }

    public WorkflowlogRequest workflowlogs_expiredprocess(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("workflowlogs_expiredprocess").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public WorkflowRequest processid() {
        return new WorkflowRequest(contextPath.addSegment("processid"), Optional.empty());
    }

    public ProcessstageRequest activestageid() {
        return new ProcessstageRequest(contextPath.addSegment("activestageid"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfbyname"), Optional.empty());
    }

    public SystemuserRequest modifiedbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedbyname"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfbyname"), Optional.empty());
    }

}
