package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Datalakeworkspace;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DatalakeworkspacepermissionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class DatalakeworkspaceRequest extends EntityRequest<Datalakeworkspace> {

    public DatalakeworkspaceRequest(ContextPath contextPath, Optional<Object> value) {
        super(Datalakeworkspace.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SyncerrorCollectionRequest datalakeworkspace_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest datalakeworkspace_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("datalakeworkspace_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest datalakeworkspace_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest datalakeworkspace_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("datalakeworkspace_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest datalakeworkspace_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest datalakeworkspace_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("datalakeworkspace_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest datalakeworkspace_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest datalakeworkspace_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("datalakeworkspace_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest datalakeworkspace_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest datalakeworkspace_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("datalakeworkspace_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest datalakeworkspace_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest datalakeworkspace_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("datalakeworkspace_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest datalakeworkspace_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest datalakeworkspace_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("datalakeworkspace_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest datalakeworkspace_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest datalakeworkspace_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("datalakeworkspace_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public DatalakeworkspacepermissionCollectionRequest datalakeworkspace_workspacepermission() {
        return new DatalakeworkspacepermissionCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_workspacepermission"), Optional.empty());
    }

    public DatalakeworkspacepermissionRequest datalakeworkspace_workspacepermission(String datalakeworkspacepermissionid) {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("datalakeworkspace_workspacepermission").addKeys(new NameValue(datalakeworkspacepermissionid.toString())), Optional.empty());
    }

}
