package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Asyncoperation;
import microsoft.dynamics.crm.entity.collection.request.BulkdeleteoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;

@JsonIgnoreType
public class AsyncoperationRequest extends EntityRequest<Asyncoperation> {

    public AsyncoperationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Asyncoperation.class, contextPath, value, false);
    }

    public ThemeRequest regardingobjectid_theme() {
        return new ThemeRequest(contextPath.addSegment("regardingobjectid_theme"), Optional.empty());
    }

    public UsermappingRequest regardingobjectid_usermapping() {
        return new UsermappingRequest(contextPath.addSegment("regardingobjectid_usermapping"), Optional.empty());
    }

    public InteractionforemailRequest regardingobjectid_new_interactionforemail() {
        return new InteractionforemailRequest(contextPath.addSegment("regardingobjectid_new_interactionforemail"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), Optional.empty());
    }

    public PostRequest regardingobjectid_post() {
        return new PostRequest(contextPath.addSegment("regardingobjectid_post"), Optional.empty());
    }

    public PositionRequest regardingobjectid_position() {
        return new PositionRequest(contextPath.addSegment("regardingobjectid_position"), Optional.empty());
    }

    public SimilarityruleRequest regardingobjectid_similarityrule() {
        return new SimilarityruleRequest(contextPath.addSegment("regardingobjectid_similarityrule"), Optional.empty());
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord"), Optional.empty());
    }

    public ReportRequest regardingobjectid_report() {
        return new ReportRequest(contextPath.addSegment("regardingobjectid_report"), Optional.empty());
    }

    public EmailCollectionRequest asyncOperation_Emails() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("AsyncOperation_Emails"), Optional.empty());
    }

    public EmailRequest asyncOperation_Emails(String activityid) {
        return new EmailRequest(contextPath.addSegment("AsyncOperation_Emails").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public RecurringappointmentmasterRequest regardingobjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("regardingobjectid_recurringappointmentmaster"), Optional.empty());
    }

    public PrivilegeRequest regardingobjectid_privilege() {
        return new PrivilegeRequest(contextPath.addSegment("regardingobjectid_privilege"), Optional.empty());
    }

    public BulkdeleteoperationCollectionRequest asyncOperation_BulkDeleteOperation() {
        return new BulkdeleteoperationCollectionRequest(
                        contextPath.addSegment("AsyncOperation_BulkDeleteOperation"), Optional.empty());
    }

    public BulkdeleteoperationRequest asyncOperation_BulkDeleteOperation(String bulkdeleteoperationid) {
        return new BulkdeleteoperationRequest(contextPath.addSegment("AsyncOperation_BulkDeleteOperation").addKeys(new NameValue(bulkdeleteoperationid.toString())), Optional.empty());
    }

    public GoalrollupqueryRequest regardingobjectid_goalrollupquery() {
        return new GoalrollupqueryRequest(contextPath.addSegment("regardingobjectid_goalrollupquery"), Optional.empty());
    }

    public SocialactivityCollectionRequest asyncOperation_SocialActivities() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("AsyncOperation_SocialActivities"), Optional.empty());
    }

    public SocialactivityRequest asyncOperation_SocialActivities(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("AsyncOperation_SocialActivities").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public PostfollowRequest regardingobjectid_postfollow() {
        return new PostfollowRequest(contextPath.addSegment("regardingobjectid_postfollow"), Optional.empty());
    }

    public BusinessunitRequest regardingobjectid_businessunit() {
        return new BusinessunitRequest(contextPath.addSegment("regardingobjectid_businessunit"), Optional.empty());
    }

    public AnnualfiscalcalendarRequest regardingobjectid_annualfiscalcalendar() {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_annualfiscalcalendar"), Optional.empty());
    }

    public WorkflowRequest workflowactivationid() {
        return new WorkflowRequest(contextPath.addSegment("workflowactivationid"), Optional.empty());
    }

    public MonthlyfiscalcalendarRequest regardingobjectid_monthlyfiscalcalendar() {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_monthlyfiscalcalendar"), Optional.empty());
    }

    public MailboxRequest regardingobjectid_mailbox() {
        return new MailboxRequest(contextPath.addSegment("regardingobjectid_mailbox"), Optional.empty());
    }

    public ImportfileRequest regardingobjectid_importfile() {
        return new ImportfileRequest(contextPath.addSegment("regardingobjectid_importfile"), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_asyncoperation_childworkflow() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_asyncoperation_childworkflow"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_asyncoperation_childworkflow(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_asyncoperation_childworkflow").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public ImportdataRequest regardingobjectid_importdata() {
        return new ImportdataRequest(contextPath.addSegment("regardingobjectid_importdata"), Optional.empty());
    }

    public EmailRequest regardingobjectid_email() {
        return new EmailRequest(contextPath.addSegment("regardingobjectid_email"), Optional.empty());
    }

    public TeamRequest regardingobjectid_team() {
        return new TeamRequest(contextPath.addSegment("regardingobjectid_team"), Optional.empty());
    }

    public DuplicaterecordCollectionRequest asyncOperation_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("AsyncOperation_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest asyncOperation_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("AsyncOperation_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public KbarticletemplateRequest regardingobjectid_kbarticletemplate() {
        return new KbarticletemplateRequest(contextPath.addSegment("regardingobjectid_kbarticletemplate"), Optional.empty());
    }

    public EmailserverprofileRequest regardingobjectid_emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("regardingobjectid_emailserverprofile"), Optional.empty());
    }

    public UserformRequest regardingobjectid_userform() {
        return new UserformRequest(contextPath.addSegment("regardingobjectid_userform"), Optional.empty());
    }

    public TransactioncurrencyRequest regardingobjectid_transactioncurrency() {
        return new TransactioncurrencyRequest(contextPath.addSegment("regardingobjectid_transactioncurrency"), Optional.empty());
    }

    public SocialprofileRequest regardingobjectid_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("regardingobjectid_socialprofile"), Optional.empty());
    }

    public ImportmapRequest regardingobjectid_importmap() {
        return new ImportmapRequest(contextPath.addSegment("regardingobjectid_importmap"), Optional.empty());
    }

    public AccountRequest regardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), Optional.empty());
    }

    public PhonecallRequest regardingobjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("regardingobjectid_phonecall"), Optional.empty());
    }

    public SocialactivityRequest regardingobjectid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("regardingobjectid_socialactivity"), Optional.empty());
    }

    public QueueitemRequest regardingobjectid_queueitem() {
        return new QueueitemRequest(contextPath.addSegment("regardingobjectid_queueitem"), Optional.empty());
    }

    public QuarterlyfiscalcalendarRequest regardingobjectid_quarterlyfiscalcalendar() {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_quarterlyfiscalcalendar"), Optional.empty());
    }

    public QueueRequest regardingobjectid_queue() {
        return new QueueRequest(contextPath.addSegment("regardingobjectid_queue"), Optional.empty());
    }

    public TemplateRequest regardingobjectid_template() {
        return new TemplateRequest(contextPath.addSegment("regardingobjectid_template"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public KbarticleRequest regardingobjectid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("regardingobjectid_kbarticle"), Optional.empty());
    }

    public SystemformRequest regardingobjectid_systemform() {
        return new SystemformRequest(contextPath.addSegment("regardingobjectid_systemform"), Optional.empty());
    }

    public DisplaystringRequest regardingobjectid_displaystring() {
        return new DisplaystringRequest(contextPath.addSegment("regardingobjectid_displaystring"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public OrganizationRequest regardingobjectid_organization() {
        return new OrganizationRequest(contextPath.addSegment("regardingobjectid_organization"), Optional.empty());
    }

    public ConnectionroleRequest regardingobjectid_connectionrole() {
        return new ConnectionroleRequest(contextPath.addSegment("regardingobjectid_connectionrole"), Optional.empty());
    }

    public KbarticlecommentRequest regardingobjectid_kbarticlecomment() {
        return new KbarticlecommentRequest(contextPath.addSegment("regardingobjectid_kbarticlecomment"), Optional.empty());
    }

    public AppointmentRequest regardingobjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("regardingobjectid_appointment"), Optional.empty());
    }

    public SystemuserRequest regardingobjectid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("regardingobjectid_systemuser"), Optional.empty());
    }

    public MailmergetemplateRequest regardingobjectid_mailmergetemplate() {
        return new MailmergetemplateRequest(contextPath.addSegment("regardingobjectid_mailmergetemplate"), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest asyncOperation_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("AsyncOperation_MailboxTrackingFolder"), Optional.empty());
    }

    public MailboxtrackingfolderRequest asyncOperation_MailboxTrackingFolder(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("AsyncOperation_MailboxTrackingFolder").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public CalendarRequest regardingobjectid_calendar() {
        return new CalendarRequest(contextPath.addSegment("regardingobjectid_calendar"), Optional.empty());
    }

    public RollupfieldRequest regardingobjectid_rollupfield() {
        return new RollupfieldRequest(contextPath.addSegment("regardingobjectid_rollupfield"), Optional.empty());
    }

    public ConnectionRequest regardingobjectid_connection() {
        return new ConnectionRequest(contextPath.addSegment("regardingobjectid_connection"), Optional.empty());
    }

    public MetricRequest regardingobjectid_metric() {
        return new MetricRequest(contextPath.addSegment("regardingobjectid_metric"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public RoleRequest regardingobjectid_role() {
        return new RoleRequest(contextPath.addSegment("regardingobjectid_role"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SubjectRequest regardingobjectid_subject() {
        return new SubjectRequest(contextPath.addSegment("regardingobjectid_subject"), Optional.empty());
    }

    public SavedqueryRequest regardingobjectid_savedquery() {
        return new SavedqueryRequest(contextPath.addSegment("regardingobjectid_savedquery"), Optional.empty());
    }

    public SlaRequest regardingobjectid_sla() {
        return new SlaRequest(contextPath.addSegment("regardingobjectid_sla"), Optional.empty());
    }

    public ActivitymimeattachmentRequest regardingobjectid_activitymimeattachment() {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("regardingobjectid_activitymimeattachment"), Optional.empty());
    }

    public LetterRequest regardingobjectid_letter() {
        return new LetterRequest(contextPath.addSegment("regardingobjectid_letter"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public AnnotationRequest regardingobjectid_annotation() {
        return new AnnotationRequest(contextPath.addSegment("regardingobjectid_annotation"), Optional.empty());
    }

    public UserqueryRequest regardingobjectid_userquery() {
        return new UserqueryRequest(contextPath.addSegment("regardingobjectid_userquery"), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_asyncoperations() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_asyncoperations"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_asyncoperations(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_asyncoperations").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public TaskRequest regardingobjectid_task() {
        return new TaskRequest(contextPath.addSegment("regardingobjectid_task"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact"), Optional.empty());
    }

    public SharepointsiteRequest regardingobjectid_sharepointsite() {
        return new SharepointsiteRequest(contextPath.addSegment("regardingobjectid_sharepointsite"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest owningextensionid() {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("owningextensionid"), Optional.empty());
    }

    public BusinessunitnewsarticleRequest regardingobjectid_businessunitnewsarticle() {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("regardingobjectid_businessunitnewsarticle"), Optional.empty());
    }

    public GoalRequest regardingobjectid_goal() {
        return new GoalRequest(contextPath.addSegment("regardingobjectid_goal"), Optional.empty());
    }

    public ImportlogRequest regardingobjectid_importlog() {
        return new ImportlogRequest(contextPath.addSegment("regardingobjectid_importlog"), Optional.empty());
    }

    public SemiannualfiscalcalendarRequest regardingobjectid_semiannualfiscalcalendar() {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_semiannualfiscalcalendar"), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarRequest regardingobjectid_fixedmonthlyfiscalcalendar() {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_fixedmonthlyfiscalcalendar"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public CustomeraddressRequest regardingobjectid_customeraddress() {
        return new CustomeraddressRequest(contextPath.addSegment("regardingobjectid_customeraddress"), Optional.empty());
    }

    public FaxRequest regardingobjectid_fax() {
        return new FaxRequest(contextPath.addSegment("regardingobjectid_fax"), Optional.empty());
    }

    public SharepointdocumentlocationRequest regardingobjectid_sharepointdocumentlocation() {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("regardingobjectid_sharepointdocumentlocation"), Optional.empty());
    }

    public ActivitypointerRequest regardingobjectid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("regardingobjectid_activitypointer"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public ImportRequest regardingobjectid_import() {
        return new ImportRequest(contextPath.addSegment("regardingobjectid_import"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest regardingobjectid_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentattributeconfiguration"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest regardingobjectid_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentconfiguration"), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationRequest regardingobjectid_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentrelationshipconfiguration"), Optional.empty());
    }

    public StagesolutionuploadRequest regardingobjectid_stagesolutionupload() {
        return new StagesolutionuploadRequest(contextPath.addSegment("regardingobjectid_stagesolutionupload"), Optional.empty());
    }

    public ExportsolutionuploadRequest regardingobjectid_exportsolutionupload() {
        return new ExportsolutionuploadRequest(contextPath.addSegment("regardingobjectid_exportsolutionupload"), Optional.empty());
    }

    public AttributeimageconfigRequest regardingobjectid_attributeimageconfig() {
        return new AttributeimageconfigRequest(contextPath.addSegment("regardingobjectid_attributeimageconfig"), Optional.empty());
    }

    public EntityimageconfigRequest regardingobjectid_entityimageconfig() {
        return new EntityimageconfigRequest(contextPath.addSegment("regardingobjectid_entityimageconfig"), Optional.empty());
    }

    public EntityanalyticsconfigRequest regardingobjectid_entityanalyticsconfig() {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("regardingobjectid_entityanalyticsconfig"), Optional.empty());
    }

    public RelationshipattributeRequest regardingobjectid_relationshipattribute() {
        return new RelationshipattributeRequest(contextPath.addSegment("regardingobjectid_relationshipattribute"), Optional.empty());
    }

    public DatalakeworkspaceRequest regardingobjectid_datalakeworkspace() {
        return new DatalakeworkspaceRequest(contextPath.addSegment("regardingobjectid_datalakeworkspace"), Optional.empty());
    }

    public DatalakeworkspacepermissionRequest regardingobjectid_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("regardingobjectid_datalakeworkspacepermission"), Optional.empty());
    }

    public ApplicationuserRequest regardingobjectid_applicationuser() {
        return new ApplicationuserRequest(contextPath.addSegment("regardingobjectid_applicationuser"), Optional.empty());
    }

    public FileattachmentCollectionRequest asyncoperation_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("asyncoperation_FileAttachments"), Optional.empty());
    }

    public FileattachmentRequest asyncoperation_FileAttachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("asyncoperation_FileAttachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

    public FileattachmentRequest datablobid() {
        return new FileattachmentRequest(contextPath.addSegment("datablobid"), Optional.empty());
    }

    public ServiceplanRequest regardingobjectid_serviceplan() {
        return new ServiceplanRequest(contextPath.addSegment("regardingobjectid_serviceplan"), Optional.empty());
    }

    public ConnectorRequest regardingobjectid_connector() {
        return new ConnectorRequest(contextPath.addSegment("regardingobjectid_connector"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest regardingobjectid_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("regardingobjectid_environmentvariabledefinition"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest regardingobjectid_environmentvariablevalue() {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("regardingobjectid_environmentvariablevalue"), Optional.empty());
    }

    public ProcessstageparameterRequest regardingobjectid_processstageparameter() {
        return new ProcessstageparameterRequest(contextPath.addSegment("regardingobjectid_processstageparameter"), Optional.empty());
    }

    public FlowsessionRequest regardingobjectid_flowsession() {
        return new FlowsessionRequest(contextPath.addSegment("regardingobjectid_flowsession"), Optional.empty());
    }

    public WorkflowbinaryRequest regardingobjectid_workflowbinary() {
        return new WorkflowbinaryRequest(contextPath.addSegment("regardingobjectid_workflowbinary"), Optional.empty());
    }

    public ConnectionreferenceRequest regardingobjectid_connectionreference() {
        return new ConnectionreferenceRequest(contextPath.addSegment("regardingobjectid_connectionreference"), Optional.empty());
    }

    public Msdyn_helppageRequest regardingobjectid_msdyn_helppage() {
        return new Msdyn_helppageRequest(contextPath.addSegment("regardingobjectid_msdyn_helppage"), Optional.empty());
    }

    public TerritoryRequest regardingobjectid_territory() {
        return new TerritoryRequest(contextPath.addSegment("regardingobjectid_territory"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest regardingobjectid_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("regardingobjectid_msdyn_serviceconfiguration"), Optional.empty());
    }

    public Msdyn_slakpiRequest regardingobjectid_msdyn_slakpi() {
        return new Msdyn_slakpiRequest(contextPath.addSegment("regardingobjectid_msdyn_slakpi"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest regardingobjectid_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticleimage"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest regardingobjectid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticletemplate"), Optional.empty());
    }

    public Msdyn_dataflowRequest regardingobjectid_msdyn_dataflow() {
        return new Msdyn_dataflowRequest(contextPath.addSegment("regardingobjectid_msdyn_dataflow"), Optional.empty());
    }

    public Msdyn_richtextfileRequest regardingobjectid_msdyn_richtextfile() {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("regardingobjectid_msdyn_richtextfile"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest regardingobjectid_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("regardingobjectid_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aimodelRequest regardingobjectid_msdyn_aimodel() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("regardingobjectid_msdyn_aimodel"), Optional.empty());
    }

    public Msdyn_aitemplateRequest regardingobjectid_msdyn_aitemplate() {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_aitemplate"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest regardingobjectid_msdyn_aibdataset() {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdataset"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest regardingobjectid_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetfile"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest regardingobjectid_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetrecord"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest regardingobjectid_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetscontainer"), Optional.empty());
    }

    public Msdyn_aibfileRequest regardingobjectid_msdyn_aibfile() {
        return new Msdyn_aibfileRequest(contextPath.addSegment("regardingobjectid_msdyn_aibfile"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest regardingobjectid_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("regardingobjectid_msdyn_aibfileattacheddata"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest regardingobjectid_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("regardingobjectid_msdyn_aifptrainingdocument"), Optional.empty());
    }

    public Msdyn_aiodimageRequest regardingobjectid_msdyn_aiodimage() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodimage"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest regardingobjectid_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodlabel"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest regardingobjectid_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodtrainingboundingbox"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest regardingobjectid_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodtrainingimage"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest regardingobjectid_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("regardingobjectid_msdyn_analysiscomponent"), Optional.empty());
    }

    public Msdyn_analysisjobRequest regardingobjectid_msdyn_analysisjob() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisjob"), Optional.empty());
    }

    public Msdyn_analysisresultRequest regardingobjectid_msdyn_analysisresult() {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisresult"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest regardingobjectid_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisresultdetail"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest regardingobjectid_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthrule"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest regardingobjectid_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthruleargument"), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetRequest regardingobjectid_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthruleset"), Optional.empty());
    }

    public Ggw_eventRequest regardingobjectid_ggw_event() {
        return new Ggw_eventRequest(contextPath.addSegment("regardingobjectid_ggw_event"), Optional.empty());
    }

    public Ggw_teamRequest regardingobjectid_ggw_team() {
        return new Ggw_teamRequest(contextPath.addSegment("regardingobjectid_ggw_team"), Optional.empty());
    }

    public Ggw_crewRequest regardingobjectid_ggw_crew() {
        return new Ggw_crewRequest(contextPath.addSegment("regardingobjectid_ggw_crew"), Optional.empty());
    }

    public Ggw_team_applicationRequest regardingobjectid_ggw_team_application() {
        return new Ggw_team_applicationRequest(contextPath.addSegment("regardingobjectid_ggw_team_application"), Optional.empty());
    }

    public CascadegrantrevokeaccessrecordstrackerRequest regardingobjectid_cascadegrantrevokeaccessrecordstracker() {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("regardingobjectid_cascadegrantrevokeaccessrecordstracker"), Optional.empty());
    }

    public CascadegrantrevokeaccessversiontrackerRequest regardingobjectid_cascadegrantrevokeaccessversiontracker() {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("regardingobjectid_cascadegrantrevokeaccessversiontracker"), Optional.empty());
    }

}
