package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Workflowbinary;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.WorkflowbinaryRequest;

public class WorkflowbinaryCollectionRequest extends CollectionPageEntityRequest<Workflowbinary, WorkflowbinaryRequest>{

    protected ContextPath contextPath;

    public WorkflowbinaryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Workflowbinary.class, cp -> new WorkflowbinaryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest workflowbinary_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("workflowbinary_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest workflowbinary_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("workflowbinary_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest workflowbinary_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("workflowbinary_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest workflowbinary_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("workflowbinary_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest workflowbinary_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("workflowbinary_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest workflowbinary_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("workflowbinary_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest workflowbinary_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("workflowbinary_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest workflowbinary_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("workflowbinary_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest workflowbinary_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("workflowbinary_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest workflowbinary_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("workflowbinary_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest workflowbinary_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("workflowbinary_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest workflowbinary_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("workflowbinary_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public FileattachmentCollectionRequest workflowbinary_FileAttachments() {
        return new FileattachmentCollectionRequest(contextPath.addSegment("workflowbinary_FileAttachments"), Optional.empty());
    }

    public FileattachmentRequest workflowbinary_FileAttachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("workflowbinary_FileAttachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

}
