package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Monthlyfiscalcalendar;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.MonthlyfiscalcalendarRequest;

public class MonthlyfiscalcalendarCollectionRequest extends CollectionPageEntityRequest<Monthlyfiscalcalendar, MonthlyfiscalcalendarRequest>{

    protected ContextPath contextPath;

    public MonthlyfiscalcalendarCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Monthlyfiscalcalendar.class, cp -> new MonthlyfiscalcalendarRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest monthlyFiscalCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("MonthlyFiscalCalendar_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest monthlyFiscalCalendar_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("MonthlyFiscalCalendar_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest monthlyFiscalCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("MonthlyFiscalCalendar_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest monthlyFiscalCalendar_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("MonthlyFiscalCalendar_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

}
