package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Ggw_team;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Ggw_teamCollectionRequest extends CollectionPageEntityRequest<Ggw_team, Ggw_teamRequest>{

    protected ContextPath contextPath;

    public Ggw_teamCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Ggw_team.class, cp -> new Ggw_teamRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest ggw_team_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ggw_team_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest ggw_team_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ggw_team_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest ggw_team_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("ggw_team_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest ggw_team_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("ggw_team_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest ggw_team_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("ggw_team_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest ggw_team_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("ggw_team_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest ggw_team_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("ggw_team_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest ggw_team_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ggw_team_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest ggw_team_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("ggw_team_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest ggw_team_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("ggw_team_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest ggw_team_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("ggw_team_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest ggw_team_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("ggw_team_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest ggw_team_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("ggw_team_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest ggw_team_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ggw_team_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest ggw_team_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("ggw_team_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest ggw_team_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("ggw_team_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public Ggw_crewCollectionRequest ggw_ggw_crew_ggw_team() {
        return new Ggw_crewCollectionRequest(contextPath.addSegment("ggw_ggw_crew_ggw_team"), Optional.empty());
    }

    public Ggw_crewRequest ggw_ggw_crew_ggw_team(String ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("ggw_ggw_crew_ggw_team").addKeys(new NameValue(ggw_crewid.toString())), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest ggw_ggw_team_ggw_team_application() {
        return new Ggw_team_applicationCollectionRequest(contextPath.addSegment("ggw_ggw_team_ggw_team_application"), Optional.empty());
    }

    public Ggw_team_applicationRequest ggw_ggw_team_ggw_team_application(String ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("ggw_ggw_team_ggw_team_application").addKeys(new NameValue(ggw_team_applicationid.toString())), Optional.empty());
    }

}
