package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Appconfiginstance;
import microsoft.dynamics.crm.entity.request.AppconfiginstanceRequest;

public class AppconfiginstanceCollectionRequest extends CollectionPageEntityRequest<Appconfiginstance, AppconfiginstanceRequest>{

    protected ContextPath contextPath;

    public AppconfiginstanceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Appconfiginstance.class, cp -> new AppconfiginstanceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "RetrieveUnpublishedMultiple")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Appconfiginstance> retrieveUnpublishedMultiple() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublishedMultiple"), Appconfiginstance.class, _parameters);
    }

}
