package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TerritoryCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "utcconversiontimezonecode", 
    "_modifiedby_value", 
    "entityimage_url", 
    "versionnumber", 
    "entityimage_timestamp", 
    "_managerid_value", 
    "createdon", 
    "importsequencenumber", 
    "territoryid", 
    "description", 
    "modifiedon", 
    "exchangerate", 
    "_organizationid_value", 
    "_modifiedonbehalfby_value", 
    "overriddencreatedon", 
    "entityimage", 
    "_parentterritoryid_value", 
    "_transactioncurrencyid_value", 
    "_createdby_value", 
    "_createdonbehalfby_value", 
    "timezoneruleversionnumber", 
    "name", 
    "entityimageid"})
@JsonInclude(Include.NON_NULL)
public class Territory extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.territory";
    }

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("entityimage_url")
    protected String entityimage_url;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("entityimage_timestamp")
    protected Long entityimage_timestamp;

    @JsonProperty("_managerid_value")
    protected String _managerid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("territoryid")
    protected String territoryid;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("entityimage")
    protected byte[] entityimage;

    @JsonProperty("_parentterritoryid_value")
    protected String _parentterritoryid_value;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("entityimageid")
    protected String entityimageid;

    protected Territory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTerritory() {
        return new Builder();
    }

    public static final class Builder {
        private Integer utcconversiontimezonecode;
        private String _modifiedby_value;
        private String entityimage_url;
        private Long versionnumber;
        private Long entityimage_timestamp;
        private String _managerid_value;
        private OffsetDateTime createdon;
        private Integer importsequencenumber;
        private String territoryid;
        private String description;
        private OffsetDateTime modifiedon;
        private BigDecimal exchangerate;
        private String _organizationid_value;
        private String _modifiedonbehalfby_value;
        private OffsetDateTime overriddencreatedon;
        private byte[] entityimage;
        private String _parentterritoryid_value;
        private String _transactioncurrencyid_value;
        private String _createdby_value;
        private String _createdonbehalfby_value;
        private Integer timezoneruleversionnumber;
        private String name;
        private String entityimageid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder entityimage_url(String entityimage_url) {
            this.entityimage_url = entityimage_url;
            this.changedFields = changedFields.add("entityimage_url");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder entityimage_timestamp(Long entityimage_timestamp) {
            this.entityimage_timestamp = entityimage_timestamp;
            this.changedFields = changedFields.add("entityimage_timestamp");
            return this;
        }

        public Builder _managerid_value(String _managerid_value) {
            this._managerid_value = _managerid_value;
            this.changedFields = changedFields.add("_managerid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder territoryid(String territoryid) {
            this.territoryid = territoryid;
            this.changedFields = changedFields.add("territoryid");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder entityimage(byte[] entityimage) {
            this.entityimage = entityimage;
            this.changedFields = changedFields.add("entityimage");
            return this;
        }

        public Builder _parentterritoryid_value(String _parentterritoryid_value) {
            this._parentterritoryid_value = _parentterritoryid_value;
            this.changedFields = changedFields.add("_parentterritoryid_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder entityimageid(String entityimageid) {
            this.entityimageid = entityimageid;
            this.changedFields = changedFields.add("entityimageid");
            return this;
        }

        public Territory build() {
            Territory _x = new Territory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.territory";
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._modifiedby_value = _modifiedby_value;
            _x.entityimage_url = entityimage_url;
            _x.versionnumber = versionnumber;
            _x.entityimage_timestamp = entityimage_timestamp;
            _x._managerid_value = _managerid_value;
            _x.createdon = createdon;
            _x.importsequencenumber = importsequencenumber;
            _x.territoryid = territoryid;
            _x.description = description;
            _x.modifiedon = modifiedon;
            _x.exchangerate = exchangerate;
            _x._organizationid_value = _organizationid_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.entityimage = entityimage;
            _x._parentterritoryid_value = _parentterritoryid_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x._createdby_value = _createdby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.name = name;
            _x.entityimageid = entityimageid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && territoryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(territoryid.toString()));
        }
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Territory withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Territory with_modifiedby_value(String _modifiedby_value) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="entityimage_url")
    @JsonIgnore
    public Optional<String> getEntityimage_url() {
        return Optional.ofNullable(entityimage_url);
    }

    public Territory withEntityimage_url(String entityimage_url) {
        Checks.checkIsAscii(entityimage_url);
        Territory _x = _copy();
        _x.changedFields = changedFields.add("entityimage_url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.entityimage_url = entityimage_url;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Territory withVersionnumber(Long versionnumber) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="entityimage_timestamp")
    @JsonIgnore
    public Optional<Long> getEntityimage_timestamp() {
        return Optional.ofNullable(entityimage_timestamp);
    }

    public Territory withEntityimage_timestamp(Long entityimage_timestamp) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("entityimage_timestamp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.entityimage_timestamp = entityimage_timestamp;
        return _x;
    }

    @Property(name="_managerid_value")
    @JsonIgnore
    public Optional<String> get_managerid_value() {
        return Optional.ofNullable(_managerid_value);
    }

    public Territory with_managerid_value(String _managerid_value) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("_managerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x._managerid_value = _managerid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Territory withCreatedon(OffsetDateTime createdon) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Territory withImportsequencenumber(Integer importsequencenumber) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="territoryid")
    @JsonIgnore
    public Optional<String> getTerritoryid() {
        return Optional.ofNullable(territoryid);
    }

    public Territory withTerritoryid(String territoryid) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("territoryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.territoryid = territoryid;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Territory withDescription(String description) {
        Checks.checkIsAscii(description);
        Territory _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.description = description;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Territory withModifiedon(OffsetDateTime modifiedon) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Territory withExchangerate(BigDecimal exchangerate) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Territory with_organizationid_value(String _organizationid_value) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Territory with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Territory withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="entityimage")
    @JsonIgnore
    public Optional<byte[]> getEntityimage() {
        return Optional.ofNullable(entityimage);
    }

    public Territory withEntityimage(byte[] entityimage) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("entityimage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.entityimage = entityimage;
        return _x;
    }

    @Property(name="_parentterritoryid_value")
    @JsonIgnore
    public Optional<String> get_parentterritoryid_value() {
        return Optional.ofNullable(_parentterritoryid_value);
    }

    public Territory with_parentterritoryid_value(String _parentterritoryid_value) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("_parentterritoryid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x._parentterritoryid_value = _parentterritoryid_value;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Territory with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Territory with_createdby_value(String _createdby_value) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Territory with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Territory withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Territory withName(String name) {
        Checks.checkIsAscii(name);
        Territory _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.name = name;
        return _x;
    }

    @Property(name="entityimageid")
    @JsonIgnore
    public Optional<String> getEntityimageid() {
        return Optional.ofNullable(entityimageid);
    }

    public Territory withEntityimageid(String entityimageid) {
        Territory _x = _copy();
        _x.changedFields = changedFields.add("entityimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.territory");
        _x.entityimageid = entityimageid;
        return _x;
    }

    public Territory withUnmappedField(String name, String value) {
        Territory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="Territory_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getTerritory_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Territory_SyncErrors"), RequestHelper.getValue(unmappedFields, "Territory_SyncErrors"));
    }

    @NavigationProperty(name="Territory_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getTerritory_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Territory_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Territory_AsyncOperations"));
    }

    @NavigationProperty(name="territory_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getTerritory_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("territory_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "territory_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="Territory_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getTerritory_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Territory_ProcessSessions"), RequestHelper.getValue(unmappedFields, "Territory_ProcessSessions"));
    }

    @NavigationProperty(name="Territory_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getTerritory_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Territory_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Territory_BulkDeleteFailures"));
    }

    @NavigationProperty(name="territory_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getTerritory_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("territory_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "territory_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="territory_connections1")
    @JsonIgnore
    public ConnectionCollectionRequest getTerritory_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("territory_connections1"), RequestHelper.getValue(unmappedFields, "territory_connections1"));
    }

    @NavigationProperty(name="territory_connections2")
    @JsonIgnore
    public ConnectionCollectionRequest getTerritory_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("territory_connections2"), RequestHelper.getValue(unmappedFields, "territory_connections2"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="managerid")
    @JsonIgnore
    public SystemuserRequest getManagerid() {
        return new SystemuserRequest(contextPath.addSegment("managerid"), RequestHelper.getValue(unmappedFields, "managerid"));
    }

    @NavigationProperty(name="territory_system_users")
    @JsonIgnore
    public SystemuserCollectionRequest getTerritory_system_users() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("territory_system_users"), RequestHelper.getValue(unmappedFields, "territory_system_users"));
    }

    @NavigationProperty(name="parentterritoryid")
    @JsonIgnore
    public TerritoryRequest getParentterritoryid() {
        return new TerritoryRequest(contextPath.addSegment("parentterritoryid"), RequestHelper.getValue(unmappedFields, "parentterritoryid"));
    }

    @NavigationProperty(name="territory_parent_territory")
    @JsonIgnore
    public TerritoryCollectionRequest getTerritory_parent_territory() {
        return new TerritoryCollectionRequest(
                        contextPath.addSegment("territory_parent_territory"), RequestHelper.getValue(unmappedFields, "territory_parent_territory"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Territory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Territory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Territory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Territory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Territory _copy() {
        Territory _x = new Territory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._modifiedby_value = _modifiedby_value;
        _x.entityimage_url = entityimage_url;
        _x.versionnumber = versionnumber;
        _x.entityimage_timestamp = entityimage_timestamp;
        _x._managerid_value = _managerid_value;
        _x.createdon = createdon;
        _x.importsequencenumber = importsequencenumber;
        _x.territoryid = territoryid;
        _x.description = description;
        _x.modifiedon = modifiedon;
        _x.exchangerate = exchangerate;
        _x._organizationid_value = _organizationid_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.entityimage = entityimage;
        _x._parentterritoryid_value = _parentterritoryid_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x._createdby_value = _createdby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.name = name;
        _x.entityimageid = entityimageid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Territory[");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("entityimage_url=");
        b.append(this.entityimage_url);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("entityimage_timestamp=");
        b.append(this.entityimage_timestamp);
        b.append(", ");
        b.append("_managerid_value=");
        b.append(this._managerid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("territoryid=");
        b.append(this.territoryid);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("entityimage=");
        b.append(this.entityimage);
        b.append(", ");
        b.append("_parentterritoryid_value=");
        b.append(this._parentterritoryid_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("entityimageid=");
        b.append(this.entityimageid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
