package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentattributeconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.EntityRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "_organizationid_value", 
    "iscustomizable", 
    "fileformat", 
    "timezoneruleversionnumber", 
    "_entityid_value", 
    "versionnumber", 
    "statuscode", 
    "ismanaged", 
    "filescope", 
    "modifiedon", 
    "statecode", 
    "_createdonbehalfby_value", 
    "_modifiedby_value", 
    "isdisplayable", 
    "utcconversiontimezonecode", 
    "issoftdeleteenabled", 
    "_modifiedonbehalfby_value", 
    "componentstate", 
    "componentidunique", 
    "overwritetime", 
    "importsequencenumber", 
    "overriddencreatedon", 
    "solutioncomponentconfigurationid", 
    "createdon", 
    "solutionid", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Solutioncomponentconfiguration extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.solutioncomponentconfiguration";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("fileformat")
    protected Integer fileformat;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_entityid_value")
    protected String _entityid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("filescope")
    protected Integer filescope;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("isdisplayable")
    protected Boolean isdisplayable;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("issoftdeleteenabled")
    protected Boolean issoftdeleteenabled;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("componentidunique")
    protected String componentidunique;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("solutioncomponentconfigurationid")
    protected String solutioncomponentconfigurationid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    protected Solutioncomponentconfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSolutioncomponentconfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String _organizationid_value;
        private BooleanManagedProperty iscustomizable;
        private Integer fileformat;
        private Integer timezoneruleversionnumber;
        private String _entityid_value;
        private Long versionnumber;
        private Integer statuscode;
        private Boolean ismanaged;
        private Integer filescope;
        private OffsetDateTime modifiedon;
        private Integer statecode;
        private String _createdonbehalfby_value;
        private String _modifiedby_value;
        private Boolean isdisplayable;
        private Integer utcconversiontimezonecode;
        private Boolean issoftdeleteenabled;
        private String _modifiedonbehalfby_value;
        private Integer componentstate;
        private String componentidunique;
        private OffsetDateTime overwritetime;
        private Integer importsequencenumber;
        private OffsetDateTime overriddencreatedon;
        private String solutioncomponentconfigurationid;
        private OffsetDateTime createdon;
        private String solutionid;
        private String _createdby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder fileformat(Integer fileformat) {
            this.fileformat = fileformat;
            this.changedFields = changedFields.add("fileformat");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _entityid_value(String _entityid_value) {
            this._entityid_value = _entityid_value;
            this.changedFields = changedFields.add("_entityid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder filescope(Integer filescope) {
            this.filescope = filescope;
            this.changedFields = changedFields.add("filescope");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder isdisplayable(Boolean isdisplayable) {
            this.isdisplayable = isdisplayable;
            this.changedFields = changedFields.add("isdisplayable");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder issoftdeleteenabled(Boolean issoftdeleteenabled) {
            this.issoftdeleteenabled = issoftdeleteenabled;
            this.changedFields = changedFields.add("issoftdeleteenabled");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder componentidunique(String componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder solutioncomponentconfigurationid(String solutioncomponentconfigurationid) {
            this.solutioncomponentconfigurationid = solutioncomponentconfigurationid;
            this.changedFields = changedFields.add("solutioncomponentconfigurationid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Solutioncomponentconfiguration build() {
            Solutioncomponentconfiguration _x = new Solutioncomponentconfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.solutioncomponentconfiguration";
            _x.name = name;
            _x._organizationid_value = _organizationid_value;
            _x.iscustomizable = iscustomizable;
            _x.fileformat = fileformat;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._entityid_value = _entityid_value;
            _x.versionnumber = versionnumber;
            _x.statuscode = statuscode;
            _x.ismanaged = ismanaged;
            _x.filescope = filescope;
            _x.modifiedon = modifiedon;
            _x.statecode = statecode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.isdisplayable = isdisplayable;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.issoftdeleteenabled = issoftdeleteenabled;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.componentstate = componentstate;
            _x.componentidunique = componentidunique;
            _x.overwritetime = overwritetime;
            _x.importsequencenumber = importsequencenumber;
            _x.overriddencreatedon = overriddencreatedon;
            _x.solutioncomponentconfigurationid = solutioncomponentconfigurationid;
            _x.createdon = createdon;
            _x.solutionid = solutionid;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && solutioncomponentconfigurationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(solutioncomponentconfigurationid.toString()));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Solutioncomponentconfiguration withName(String name) {
        Checks.checkIsAscii(name);
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.name = name;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Solutioncomponentconfiguration with_organizationid_value(String _organizationid_value) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Solutioncomponentconfiguration withIscustomizable(BooleanManagedProperty iscustomizable) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="fileformat")
    @JsonIgnore
    public Optional<Integer> getFileformat() {
        return Optional.ofNullable(fileformat);
    }

    public Solutioncomponentconfiguration withFileformat(Integer fileformat) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("fileformat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.fileformat = fileformat;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Solutioncomponentconfiguration withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_entityid_value")
    @JsonIgnore
    public Optional<String> get_entityid_value() {
        return Optional.ofNullable(_entityid_value);
    }

    public Solutioncomponentconfiguration with_entityid_value(String _entityid_value) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_entityid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x._entityid_value = _entityid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Solutioncomponentconfiguration withVersionnumber(Long versionnumber) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Solutioncomponentconfiguration withStatuscode(Integer statuscode) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Solutioncomponentconfiguration withIsmanaged(Boolean ismanaged) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="filescope")
    @JsonIgnore
    public Optional<Integer> getFilescope() {
        return Optional.ofNullable(filescope);
    }

    public Solutioncomponentconfiguration withFilescope(Integer filescope) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("filescope");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.filescope = filescope;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Solutioncomponentconfiguration withModifiedon(OffsetDateTime modifiedon) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Solutioncomponentconfiguration withStatecode(Integer statecode) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Solutioncomponentconfiguration with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Solutioncomponentconfiguration with_modifiedby_value(String _modifiedby_value) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="isdisplayable")
    @JsonIgnore
    public Optional<Boolean> getIsdisplayable() {
        return Optional.ofNullable(isdisplayable);
    }

    public Solutioncomponentconfiguration withIsdisplayable(Boolean isdisplayable) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("isdisplayable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.isdisplayable = isdisplayable;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Solutioncomponentconfiguration withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="issoftdeleteenabled")
    @JsonIgnore
    public Optional<Boolean> getIssoftdeleteenabled() {
        return Optional.ofNullable(issoftdeleteenabled);
    }

    public Solutioncomponentconfiguration withIssoftdeleteenabled(Boolean issoftdeleteenabled) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("issoftdeleteenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.issoftdeleteenabled = issoftdeleteenabled;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Solutioncomponentconfiguration with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Solutioncomponentconfiguration withComponentstate(Integer componentstate) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<String> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Solutioncomponentconfiguration withComponentidunique(String componentidunique) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Solutioncomponentconfiguration withOverwritetime(OffsetDateTime overwritetime) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Solutioncomponentconfiguration withImportsequencenumber(Integer importsequencenumber) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Solutioncomponentconfiguration withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="solutioncomponentconfigurationid")
    @JsonIgnore
    public Optional<String> getSolutioncomponentconfigurationid() {
        return Optional.ofNullable(solutioncomponentconfigurationid);
    }

    public Solutioncomponentconfiguration withSolutioncomponentconfigurationid(String solutioncomponentconfigurationid) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("solutioncomponentconfigurationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.solutioncomponentconfigurationid = solutioncomponentconfigurationid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Solutioncomponentconfiguration withCreatedon(OffsetDateTime createdon) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Solutioncomponentconfiguration withSolutionid(String solutionid) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Solutioncomponentconfiguration with_createdby_value(String _createdby_value) {
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentconfiguration");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Solutioncomponentconfiguration withUnmappedField(String name, String value) {
        Solutioncomponentconfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="solutioncomponentconfiguration_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSolutioncomponentconfiguration_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("solutioncomponentconfiguration_SyncErrors"), RequestHelper.getValue(unmappedFields, "solutioncomponentconfiguration_SyncErrors"));
    }

    @NavigationProperty(name="solutioncomponentconfiguration_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSolutioncomponentconfiguration_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("solutioncomponentconfiguration_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "solutioncomponentconfiguration_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="solutioncomponentconfiguration_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSolutioncomponentconfiguration_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("solutioncomponentconfiguration_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "solutioncomponentconfiguration_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="solutioncomponentconfiguration_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getSolutioncomponentconfiguration_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("solutioncomponentconfiguration_AsyncOperations"), RequestHelper.getValue(unmappedFields, "solutioncomponentconfiguration_AsyncOperations"));
    }

    @NavigationProperty(name="solutioncomponentconfiguration_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getSolutioncomponentconfiguration_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("solutioncomponentconfiguration_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "solutioncomponentconfiguration_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="solutioncomponentconfiguration_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getSolutioncomponentconfiguration_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("solutioncomponentconfiguration_ProcessSession"), RequestHelper.getValue(unmappedFields, "solutioncomponentconfiguration_ProcessSession"));
    }

    @NavigationProperty(name="solutioncomponentconfiguration_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getSolutioncomponentconfiguration_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("solutioncomponentconfiguration_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "solutioncomponentconfiguration_BulkDeleteFailures"));
    }

    @NavigationProperty(name="solutioncomponentconfiguration_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getSolutioncomponentconfiguration_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("solutioncomponentconfiguration_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "solutioncomponentconfiguration_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="solutioncomponentconfig_solutioncomponentattrconfig")
    @JsonIgnore
    public SolutioncomponentattributeconfigurationCollectionRequest getSolutioncomponentconfig_solutioncomponentattrconfig() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(
                        contextPath.addSegment("solutioncomponentconfig_solutioncomponentattrconfig"), RequestHelper.getValue(unmappedFields, "solutioncomponentconfig_solutioncomponentattrconfig"));
    }

    @NavigationProperty(name="EntityId")
    @JsonIgnore
    public EntityRequest getEntityId() {
        return new EntityRequest(contextPath.addSegment("EntityId"), RequestHelper.getValue(unmappedFields, "EntityId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Solutioncomponentconfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Solutioncomponentconfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Solutioncomponentconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Solutioncomponentconfiguration _copy() {
        Solutioncomponentconfiguration _x = new Solutioncomponentconfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x._organizationid_value = _organizationid_value;
        _x.iscustomizable = iscustomizable;
        _x.fileformat = fileformat;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._entityid_value = _entityid_value;
        _x.versionnumber = versionnumber;
        _x.statuscode = statuscode;
        _x.ismanaged = ismanaged;
        _x.filescope = filescope;
        _x.modifiedon = modifiedon;
        _x.statecode = statecode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.isdisplayable = isdisplayable;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.issoftdeleteenabled = issoftdeleteenabled;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.componentstate = componentstate;
        _x.componentidunique = componentidunique;
        _x.overwritetime = overwritetime;
        _x.importsequencenumber = importsequencenumber;
        _x.overriddencreatedon = overriddencreatedon;
        _x.solutioncomponentconfigurationid = solutioncomponentconfigurationid;
        _x.createdon = createdon;
        _x.solutionid = solutionid;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Solutioncomponentconfiguration[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("fileformat=");
        b.append(this.fileformat);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_entityid_value=");
        b.append(this._entityid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("filescope=");
        b.append(this.filescope);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("isdisplayable=");
        b.append(this.isdisplayable);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("issoftdeleteenabled=");
        b.append(this.issoftdeleteenabled);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("solutioncomponentconfigurationid=");
        b.append(this.solutioncomponentconfigurationid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
