package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "kbarticletemplateid", 
    "iscustomizable", 
    "importsequencenumber", 
    "kbarticletemplateidunique", 
    "overriddencreatedon", 
    "description", 
    "languagecode", 
    "_createdonbehalfby_value", 
    "formatxml", 
    "solutionid", 
    "componentstate", 
    "structurexml", 
    "_modifiedonbehalfby_value", 
    "versionnumber", 
    "isactive", 
    "ismanaged", 
    "overwritetime", 
    "title", 
    "modifiedon", 
    "createdon", 
    "introducedversion", 
    "_organizationid_value", 
    "_createdby_value", 
    "_modifiedby_value"})
@JsonInclude(Include.NON_NULL)
public class Kbarticletemplate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.kbarticletemplate";
    }

    @JsonProperty("kbarticletemplateid")
    protected String kbarticletemplateid;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("kbarticletemplateidunique")
    protected String kbarticletemplateidunique;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("languagecode")
    protected Integer languagecode;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("formatxml")
    protected String formatxml;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("structurexml")
    protected String structurexml;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("isactive")
    protected Boolean isactive;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    protected Kbarticletemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderKbarticletemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String kbarticletemplateid;
        private BooleanManagedProperty iscustomizable;
        private Integer importsequencenumber;
        private String kbarticletemplateidunique;
        private OffsetDateTime overriddencreatedon;
        private String description;
        private Integer languagecode;
        private String _createdonbehalfby_value;
        private String formatxml;
        private String solutionid;
        private Integer componentstate;
        private String structurexml;
        private String _modifiedonbehalfby_value;
        private Long versionnumber;
        private Boolean isactive;
        private Boolean ismanaged;
        private OffsetDateTime overwritetime;
        private String title;
        private OffsetDateTime modifiedon;
        private OffsetDateTime createdon;
        private String introducedversion;
        private String _organizationid_value;
        private String _createdby_value;
        private String _modifiedby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder kbarticletemplateid(String kbarticletemplateid) {
            this.kbarticletemplateid = kbarticletemplateid;
            this.changedFields = changedFields.add("kbarticletemplateid");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder kbarticletemplateidunique(String kbarticletemplateidunique) {
            this.kbarticletemplateidunique = kbarticletemplateidunique;
            this.changedFields = changedFields.add("kbarticletemplateidunique");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder languagecode(Integer languagecode) {
            this.languagecode = languagecode;
            this.changedFields = changedFields.add("languagecode");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder formatxml(String formatxml) {
            this.formatxml = formatxml;
            this.changedFields = changedFields.add("formatxml");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder structurexml(String structurexml) {
            this.structurexml = structurexml;
            this.changedFields = changedFields.add("structurexml");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder isactive(Boolean isactive) {
            this.isactive = isactive;
            this.changedFields = changedFields.add("isactive");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Kbarticletemplate build() {
            Kbarticletemplate _x = new Kbarticletemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.kbarticletemplate";
            _x.kbarticletemplateid = kbarticletemplateid;
            _x.iscustomizable = iscustomizable;
            _x.importsequencenumber = importsequencenumber;
            _x.kbarticletemplateidunique = kbarticletemplateidunique;
            _x.overriddencreatedon = overriddencreatedon;
            _x.description = description;
            _x.languagecode = languagecode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.formatxml = formatxml;
            _x.solutionid = solutionid;
            _x.componentstate = componentstate;
            _x.structurexml = structurexml;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.versionnumber = versionnumber;
            _x.isactive = isactive;
            _x.ismanaged = ismanaged;
            _x.overwritetime = overwritetime;
            _x.title = title;
            _x.modifiedon = modifiedon;
            _x.createdon = createdon;
            _x.introducedversion = introducedversion;
            _x._organizationid_value = _organizationid_value;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && kbarticletemplateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(kbarticletemplateid.toString()));
        }
    }

    @Property(name="kbarticletemplateid")
    @JsonIgnore
    public Optional<String> getKbarticletemplateid() {
        return Optional.ofNullable(kbarticletemplateid);
    }

    public Kbarticletemplate withKbarticletemplateid(String kbarticletemplateid) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("kbarticletemplateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.kbarticletemplateid = kbarticletemplateid;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Kbarticletemplate withIscustomizable(BooleanManagedProperty iscustomizable) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Kbarticletemplate withImportsequencenumber(Integer importsequencenumber) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="kbarticletemplateidunique")
    @JsonIgnore
    public Optional<String> getKbarticletemplateidunique() {
        return Optional.ofNullable(kbarticletemplateidunique);
    }

    public Kbarticletemplate withKbarticletemplateidunique(String kbarticletemplateidunique) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("kbarticletemplateidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.kbarticletemplateidunique = kbarticletemplateidunique;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Kbarticletemplate withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Kbarticletemplate withDescription(String description) {
        Checks.checkIsAscii(description);
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.description = description;
        return _x;
    }

    @Property(name="languagecode")
    @JsonIgnore
    public Optional<Integer> getLanguagecode() {
        return Optional.ofNullable(languagecode);
    }

    public Kbarticletemplate withLanguagecode(Integer languagecode) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("languagecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.languagecode = languagecode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Kbarticletemplate with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="formatxml")
    @JsonIgnore
    public Optional<String> getFormatxml() {
        return Optional.ofNullable(formatxml);
    }

    public Kbarticletemplate withFormatxml(String formatxml) {
        Checks.checkIsAscii(formatxml);
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("formatxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.formatxml = formatxml;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Kbarticletemplate withSolutionid(String solutionid) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Kbarticletemplate withComponentstate(Integer componentstate) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="structurexml")
    @JsonIgnore
    public Optional<String> getStructurexml() {
        return Optional.ofNullable(structurexml);
    }

    public Kbarticletemplate withStructurexml(String structurexml) {
        Checks.checkIsAscii(structurexml);
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("structurexml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.structurexml = structurexml;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Kbarticletemplate with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Kbarticletemplate withVersionnumber(Long versionnumber) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="isactive")
    @JsonIgnore
    public Optional<Boolean> getIsactive() {
        return Optional.ofNullable(isactive);
    }

    public Kbarticletemplate withIsactive(Boolean isactive) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("isactive");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.isactive = isactive;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Kbarticletemplate withIsmanaged(Boolean ismanaged) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Kbarticletemplate withOverwritetime(OffsetDateTime overwritetime) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Kbarticletemplate withTitle(String title) {
        Checks.checkIsAscii(title);
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.title = title;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Kbarticletemplate withModifiedon(OffsetDateTime modifiedon) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Kbarticletemplate withCreatedon(OffsetDateTime createdon) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Kbarticletemplate withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Kbarticletemplate with_organizationid_value(String _organizationid_value) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Kbarticletemplate with_createdby_value(String _createdby_value) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Kbarticletemplate with_modifiedby_value(String _modifiedby_value) {
        Kbarticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.kbarticletemplate");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    public Kbarticletemplate withUnmappedField(String name, String value) {
        Kbarticletemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="KbArticleTemplate_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getKbArticleTemplate_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("KbArticleTemplate_ProcessSessions"), RequestHelper.getValue(unmappedFields, "KbArticleTemplate_ProcessSessions"));
    }

    @NavigationProperty(name="KbArticleTemplate_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getKbArticleTemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("KbArticleTemplate_AsyncOperations"), RequestHelper.getValue(unmappedFields, "KbArticleTemplate_AsyncOperations"));
    }

    @NavigationProperty(name="kb_article_template_kb_articles")
    @JsonIgnore
    public KbarticleCollectionRequest getKb_article_template_kb_articles() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("kb_article_template_kb_articles"), RequestHelper.getValue(unmappedFields, "kb_article_template_kb_articles"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="KbArticleTemplate_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getKbArticleTemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("KbArticleTemplate_SyncErrors"), RequestHelper.getValue(unmappedFields, "KbArticleTemplate_SyncErrors"));
    }

    @NavigationProperty(name="KbArticleTemplate_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getKbArticleTemplate_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("KbArticleTemplate_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "KbArticleTemplate_BulkDeleteFailures"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Kbarticletemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Kbarticletemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Kbarticletemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Kbarticletemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Kbarticletemplate _copy() {
        Kbarticletemplate _x = new Kbarticletemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.kbarticletemplateid = kbarticletemplateid;
        _x.iscustomizable = iscustomizable;
        _x.importsequencenumber = importsequencenumber;
        _x.kbarticletemplateidunique = kbarticletemplateidunique;
        _x.overriddencreatedon = overriddencreatedon;
        _x.description = description;
        _x.languagecode = languagecode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.formatxml = formatxml;
        _x.solutionid = solutionid;
        _x.componentstate = componentstate;
        _x.structurexml = structurexml;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.versionnumber = versionnumber;
        _x.isactive = isactive;
        _x.ismanaged = ismanaged;
        _x.overwritetime = overwritetime;
        _x.title = title;
        _x.modifiedon = modifiedon;
        _x.createdon = createdon;
        _x.introducedversion = introducedversion;
        _x._organizationid_value = _organizationid_value;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Kbarticletemplate[");
        b.append("kbarticletemplateid=");
        b.append(this.kbarticletemplateid);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("kbarticletemplateidunique=");
        b.append(this.kbarticletemplateidunique);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("languagecode=");
        b.append(this.languagecode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("formatxml=");
        b.append(this.formatxml);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("structurexml=");
        b.append(this.structurexml);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("isactive=");
        b.append(this.isactive);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
