package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.enums.SubCode;
import microsoft.dynamics.crm.enums.TimeCode;

@JsonPropertyOrder({
    "@odata.type", 
    "Start", 
    "End", 
    "TimeCode", 
    "SubCode", 
    "SourceId", 
    "CalendarId", 
    "SourceTypeCode", 
    "IsActivity", 
    "ActivityStatusCode", 
    "Effort", 
    "DisplayText"})
@JsonInclude(Include.NON_NULL)
public class TimeInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Start")
    protected OffsetDateTime start;

    @JsonProperty("End")
    protected OffsetDateTime end;

    @JsonProperty("TimeCode")
    protected TimeCode timeCode;

    @JsonProperty("SubCode")
    protected SubCode subCode;

    @JsonProperty("SourceId")
    protected String sourceId;

    @JsonProperty("CalendarId")
    protected String calendarId;

    @JsonProperty("SourceTypeCode")
    protected Integer sourceTypeCode;

    @JsonProperty("IsActivity")
    protected Boolean isActivity;

    @JsonProperty("ActivityStatusCode")
    protected Integer activityStatusCode;

    @JsonProperty("Effort")
    protected Double effort;

    @JsonProperty("DisplayText")
    protected String displayText;

    protected TimeInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.TimeInfo";
    }

    @Property(name="Start")
    @JsonIgnore
    public Optional<OffsetDateTime> getStart() {
        return Optional.ofNullable(start);
    }

    public TimeInfo withStart(OffsetDateTime start) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.start = start;
        return _x;
    }

    @Property(name="End")
    @JsonIgnore
    public Optional<OffsetDateTime> getEnd() {
        return Optional.ofNullable(end);
    }

    public TimeInfo withEnd(OffsetDateTime end) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.end = end;
        return _x;
    }

    @Property(name="TimeCode")
    @JsonIgnore
    public Optional<TimeCode> getTimeCode() {
        return Optional.ofNullable(timeCode);
    }

    public TimeInfo withTimeCode(TimeCode timeCode) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.timeCode = timeCode;
        return _x;
    }

    @Property(name="SubCode")
    @JsonIgnore
    public Optional<SubCode> getSubCode() {
        return Optional.ofNullable(subCode);
    }

    public TimeInfo withSubCode(SubCode subCode) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.subCode = subCode;
        return _x;
    }

    @Property(name="SourceId")
    @JsonIgnore
    public Optional<String> getSourceId() {
        return Optional.ofNullable(sourceId);
    }

    public TimeInfo withSourceId(String sourceId) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.sourceId = sourceId;
        return _x;
    }

    @Property(name="CalendarId")
    @JsonIgnore
    public Optional<String> getCalendarId() {
        return Optional.ofNullable(calendarId);
    }

    public TimeInfo withCalendarId(String calendarId) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.calendarId = calendarId;
        return _x;
    }

    @Property(name="SourceTypeCode")
    @JsonIgnore
    public Optional<Integer> getSourceTypeCode() {
        return Optional.ofNullable(sourceTypeCode);
    }

    public TimeInfo withSourceTypeCode(Integer sourceTypeCode) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.sourceTypeCode = sourceTypeCode;
        return _x;
    }

    @Property(name="IsActivity")
    @JsonIgnore
    public Optional<Boolean> getIsActivity() {
        return Optional.ofNullable(isActivity);
    }

    public TimeInfo withIsActivity(Boolean isActivity) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.isActivity = isActivity;
        return _x;
    }

    @Property(name="ActivityStatusCode")
    @JsonIgnore
    public Optional<Integer> getActivityStatusCode() {
        return Optional.ofNullable(activityStatusCode);
    }

    public TimeInfo withActivityStatusCode(Integer activityStatusCode) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.activityStatusCode = activityStatusCode;
        return _x;
    }

    @Property(name="Effort")
    @JsonIgnore
    public Optional<Double> getEffort() {
        return Optional.ofNullable(effort);
    }

    public TimeInfo withEffort(Double effort) {
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.effort = effort;
        return _x;
    }

    @Property(name="DisplayText")
    @JsonIgnore
    public Optional<String> getDisplayText() {
        return Optional.ofNullable(displayText);
    }

    public TimeInfo withDisplayText(String displayText) {
        Checks.checkIsAscii(displayText);
        TimeInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.TimeInfo");
        _x.displayText = displayText;
        return _x;
    }

    public TimeInfo withUnmappedField(String name, String value) {
        TimeInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime start;
        private OffsetDateTime end;
        private TimeCode timeCode;
        private SubCode subCode;
        private String sourceId;
        private String calendarId;
        private Integer sourceTypeCode;
        private Boolean isActivity;
        private Integer activityStatusCode;
        private Double effort;
        private String displayText;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder start(OffsetDateTime start) {
            this.start = start;
            this.changedFields = changedFields.add("Start");
            return this;
        }

        public Builder end(OffsetDateTime end) {
            this.end = end;
            this.changedFields = changedFields.add("End");
            return this;
        }

        public Builder timeCode(TimeCode timeCode) {
            this.timeCode = timeCode;
            this.changedFields = changedFields.add("TimeCode");
            return this;
        }

        public Builder subCode(SubCode subCode) {
            this.subCode = subCode;
            this.changedFields = changedFields.add("SubCode");
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.changedFields = changedFields.add("SourceId");
            return this;
        }

        public Builder calendarId(String calendarId) {
            this.calendarId = calendarId;
            this.changedFields = changedFields.add("CalendarId");
            return this;
        }

        public Builder sourceTypeCode(Integer sourceTypeCode) {
            this.sourceTypeCode = sourceTypeCode;
            this.changedFields = changedFields.add("SourceTypeCode");
            return this;
        }

        public Builder isActivity(Boolean isActivity) {
            this.isActivity = isActivity;
            this.changedFields = changedFields.add("IsActivity");
            return this;
        }

        public Builder activityStatusCode(Integer activityStatusCode) {
            this.activityStatusCode = activityStatusCode;
            this.changedFields = changedFields.add("ActivityStatusCode");
            return this;
        }

        public Builder effort(Double effort) {
            this.effort = effort;
            this.changedFields = changedFields.add("Effort");
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            this.changedFields = changedFields.add("DisplayText");
            return this;
        }

        public TimeInfo build() {
            TimeInfo _x = new TimeInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.TimeInfo";
            _x.start = start;
            _x.end = end;
            _x.timeCode = timeCode;
            _x.subCode = subCode;
            _x.sourceId = sourceId;
            _x.calendarId = calendarId;
            _x.sourceTypeCode = sourceTypeCode;
            _x.isActivity = isActivity;
            _x.activityStatusCode = activityStatusCode;
            _x.effort = effort;
            _x.displayText = displayText;
            return _x;
        }
    }

    private TimeInfo _copy() {
        TimeInfo _x = new TimeInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.start = start;
        _x.end = end;
        _x.timeCode = timeCode;
        _x.subCode = subCode;
        _x.sourceId = sourceId;
        _x.calendarId = calendarId;
        _x.sourceTypeCode = sourceTypeCode;
        _x.isActivity = isActivity;
        _x.activityStatusCode = activityStatusCode;
        _x.effort = effort;
        _x.displayText = displayText;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeInfo[");
        b.append("Start=");
        b.append(this.start);
        b.append(", ");
        b.append("End=");
        b.append(this.end);
        b.append(", ");
        b.append("TimeCode=");
        b.append(this.timeCode);
        b.append(", ");
        b.append("SubCode=");
        b.append(this.subCode);
        b.append(", ");
        b.append("SourceId=");
        b.append(this.sourceId);
        b.append(", ");
        b.append("CalendarId=");
        b.append(this.calendarId);
        b.append(", ");
        b.append("SourceTypeCode=");
        b.append(this.sourceTypeCode);
        b.append(", ");
        b.append("IsActivity=");
        b.append(this.isActivity);
        b.append(", ");
        b.append("ActivityStatusCode=");
        b.append(this.activityStatusCode);
        b.append(", ");
        b.append("Effort=");
        b.append(this.effort);
        b.append(", ");
        b.append("DisplayText=");
        b.append(this.displayText);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
