package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "InnerCalendarId"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_DeleteCalendarResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("InnerCalendarId")
    protected String innerCalendarId;

    protected Msdyn_DeleteCalendarResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_DeleteCalendarResponse";
    }

    @Property(name="InnerCalendarId")
    @JsonIgnore
    public Optional<String> getInnerCalendarId() {
        return Optional.ofNullable(innerCalendarId);
    }

    public Msdyn_DeleteCalendarResponse withInnerCalendarId(String innerCalendarId) {
        Checks.checkIsAscii(innerCalendarId);
        Msdyn_DeleteCalendarResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_DeleteCalendarResponse");
        _x.innerCalendarId = innerCalendarId;
        return _x;
    }

    public Msdyn_DeleteCalendarResponse withUnmappedField(String name, String value) {
        Msdyn_DeleteCalendarResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String innerCalendarId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder innerCalendarId(String innerCalendarId) {
            this.innerCalendarId = innerCalendarId;
            this.changedFields = changedFields.add("InnerCalendarId");
            return this;
        }

        public Msdyn_DeleteCalendarResponse build() {
            Msdyn_DeleteCalendarResponse _x = new Msdyn_DeleteCalendarResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_DeleteCalendarResponse";
            _x.innerCalendarId = innerCalendarId;
            return _x;
        }
    }

    private Msdyn_DeleteCalendarResponse _copy() {
        Msdyn_DeleteCalendarResponse _x = new Msdyn_DeleteCalendarResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.innerCalendarId = innerCalendarId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_DeleteCalendarResponse[");
        b.append("InnerCalendarId=");
        b.append(this.innerCalendarId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
