package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Metadata", 
    "EntityLogicalName", 
    "TotalRecordCount", 
    "PagingCookie"})
@JsonInclude(Include.NON_NULL)
public class LookupEntityResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Metadata")
    protected LookupMetadata metadata;

    @JsonProperty("EntityLogicalName")
    protected String entityLogicalName;

    @JsonProperty("TotalRecordCount")
    protected Integer totalRecordCount;

    @JsonProperty("PagingCookie")
    protected String pagingCookie;

    protected LookupEntityResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupEntityResponse";
    }

    @Property(name="Metadata")
    @JsonIgnore
    public Optional<LookupMetadata> getMetadata() {
        return Optional.ofNullable(metadata);
    }

    public LookupEntityResponse withMetadata(LookupMetadata metadata) {
        LookupEntityResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityResponse");
        _x.metadata = metadata;
        return _x;
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(entityLogicalName);
    }

    public LookupEntityResponse withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii(entityLogicalName);
        LookupEntityResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityResponse");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="TotalRecordCount")
    @JsonIgnore
    public Optional<Integer> getTotalRecordCount() {
        return Optional.ofNullable(totalRecordCount);
    }

    public LookupEntityResponse withTotalRecordCount(Integer totalRecordCount) {
        LookupEntityResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityResponse");
        _x.totalRecordCount = totalRecordCount;
        return _x;
    }

    @Property(name="PagingCookie")
    @JsonIgnore
    public Optional<String> getPagingCookie() {
        return Optional.ofNullable(pagingCookie);
    }

    public LookupEntityResponse withPagingCookie(String pagingCookie) {
        Checks.checkIsAscii(pagingCookie);
        LookupEntityResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityResponse");
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    public LookupEntityResponse withUnmappedField(String name, String value) {
        LookupEntityResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LookupMetadata metadata;
        private String entityLogicalName;
        private Integer totalRecordCount;
        private String pagingCookie;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadata(LookupMetadata metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("Metadata");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder totalRecordCount(Integer totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
            this.changedFields = changedFields.add("TotalRecordCount");
            return this;
        }

        public Builder pagingCookie(String pagingCookie) {
            this.pagingCookie = pagingCookie;
            this.changedFields = changedFields.add("PagingCookie");
            return this;
        }

        public LookupEntityResponse build() {
            LookupEntityResponse _x = new LookupEntityResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupEntityResponse";
            _x.metadata = metadata;
            _x.entityLogicalName = entityLogicalName;
            _x.totalRecordCount = totalRecordCount;
            _x.pagingCookie = pagingCookie;
            return _x;
        }
    }

    private LookupEntityResponse _copy() {
        LookupEntityResponse _x = new LookupEntityResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadata = metadata;
        _x.entityLogicalName = entityLogicalName;
        _x.totalRecordCount = totalRecordCount;
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupEntityResponse[");
        b.append("Metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("TotalRecordCount=");
        b.append(this.totalRecordCount);
        b.append(", ");
        b.append("PagingCookie=");
        b.append(this.pagingCookie);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
