package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Order", 
    "FormId", 
    "Name", 
    "IsCustomizable"})
@JsonInclude(Include.NON_NULL)
public class FormDisplayOrder implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Order")
    protected Integer order;

    @JsonProperty("FormId")
    protected String formId;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("IsCustomizable")
    protected Boolean isCustomizable;

    protected FormDisplayOrder() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.FormDisplayOrder";
    }

    @Property(name="Order")
    @JsonIgnore
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(order);
    }

    public FormDisplayOrder withOrder(Integer order) {
        FormDisplayOrder _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.order = order;
        return _x;
    }

    @Property(name="FormId")
    @JsonIgnore
    public Optional<String> getFormId() {
        return Optional.ofNullable(formId);
    }

    public FormDisplayOrder withFormId(String formId) {
        FormDisplayOrder _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.formId = formId;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public FormDisplayOrder withName(String name) {
        Checks.checkIsAscii(name);
        FormDisplayOrder _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.name = name;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<Boolean> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public FormDisplayOrder withIsCustomizable(Boolean isCustomizable) {
        FormDisplayOrder _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    public FormDisplayOrder withUnmappedField(String name, String value) {
        FormDisplayOrder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer order;
        private String formId;
        private String name;
        private Boolean isCustomizable;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder order(Integer order) {
            this.order = order;
            this.changedFields = changedFields.add("Order");
            return this;
        }

        public Builder formId(String formId) {
            this.formId = formId;
            this.changedFields = changedFields.add("FormId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder isCustomizable(Boolean isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public FormDisplayOrder build() {
            FormDisplayOrder _x = new FormDisplayOrder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.FormDisplayOrder";
            _x.order = order;
            _x.formId = formId;
            _x.name = name;
            _x.isCustomizable = isCustomizable;
            return _x;
        }
    }

    private FormDisplayOrder _copy() {
        FormDisplayOrder _x = new FormDisplayOrder();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.order = order;
        _x.formId = formId;
        _x.name = name;
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FormDisplayOrder[");
        b.append("Order=");
        b.append(this.order);
        b.append(", ");
        b.append("FormId=");
        b.append(this.formId);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
