package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AuditDetails", 
    "MoreRecords", 
    "PagingCookie", 
    "TotalRecordCount"})
@JsonInclude(Include.NON_NULL)
public class AuditDetailCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AuditDetails")
    protected List<AuditDetail> auditDetails;

    @JsonProperty("AuditDetails@nextLink")
    protected String auditDetailsNextLink;

    @JsonProperty("MoreRecords")
    protected Boolean moreRecords;

    @JsonProperty("PagingCookie")
    protected String pagingCookie;

    @JsonProperty("TotalRecordCount")
    protected Integer totalRecordCount;

    protected AuditDetailCollection() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AuditDetailCollection";
    }

    @Property(name="AuditDetails")
    @JsonIgnore
    public CollectionPage<AuditDetail> getAuditDetails() {
        return new CollectionPage<AuditDetail>(contextPath, AuditDetail.class, this.auditDetails, Optional.ofNullable(auditDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AuditDetails")
    @JsonIgnore
    public CollectionPage<AuditDetail> getAuditDetails(HttpRequestOptions options) {
        return new CollectionPage<AuditDetail>(contextPath, AuditDetail.class, this.auditDetails, Optional.ofNullable(auditDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="MoreRecords")
    @JsonIgnore
    public Optional<Boolean> getMoreRecords() {
        return Optional.ofNullable(moreRecords);
    }

    public AuditDetailCollection withMoreRecords(Boolean moreRecords) {
        AuditDetailCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AuditDetailCollection");
        _x.moreRecords = moreRecords;
        return _x;
    }

    @Property(name="PagingCookie")
    @JsonIgnore
    public Optional<String> getPagingCookie() {
        return Optional.ofNullable(pagingCookie);
    }

    public AuditDetailCollection withPagingCookie(String pagingCookie) {
        Checks.checkIsAscii(pagingCookie);
        AuditDetailCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AuditDetailCollection");
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    @Property(name="TotalRecordCount")
    @JsonIgnore
    public Optional<Integer> getTotalRecordCount() {
        return Optional.ofNullable(totalRecordCount);
    }

    public AuditDetailCollection withTotalRecordCount(Integer totalRecordCount) {
        AuditDetailCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AuditDetailCollection");
        _x.totalRecordCount = totalRecordCount;
        return _x;
    }

    public AuditDetailCollection withUnmappedField(String name, String value) {
        AuditDetailCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AuditDetail> auditDetails;
        private String auditDetailsNextLink;
        private Boolean moreRecords;
        private String pagingCookie;
        private Integer totalRecordCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder auditDetails(List<AuditDetail> auditDetails) {
            this.auditDetails = auditDetails;
            this.changedFields = changedFields.add("AuditDetails");
            return this;
        }

        public Builder auditDetails(AuditDetail... auditDetails) {
            return auditDetails(Arrays.asList(auditDetails));
        }

        public Builder auditDetailsNextLink(String auditDetailsNextLink) {
            this.auditDetailsNextLink = auditDetailsNextLink;
            this.changedFields = changedFields.add("AuditDetails");
            return this;
        }

        public Builder moreRecords(Boolean moreRecords) {
            this.moreRecords = moreRecords;
            this.changedFields = changedFields.add("MoreRecords");
            return this;
        }

        public Builder pagingCookie(String pagingCookie) {
            this.pagingCookie = pagingCookie;
            this.changedFields = changedFields.add("PagingCookie");
            return this;
        }

        public Builder totalRecordCount(Integer totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
            this.changedFields = changedFields.add("TotalRecordCount");
            return this;
        }

        public AuditDetailCollection build() {
            AuditDetailCollection _x = new AuditDetailCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AuditDetailCollection";
            _x.auditDetails = auditDetails;
            _x.auditDetailsNextLink = auditDetailsNextLink;
            _x.moreRecords = moreRecords;
            _x.pagingCookie = pagingCookie;
            _x.totalRecordCount = totalRecordCount;
            return _x;
        }
    }

    private AuditDetailCollection _copy() {
        AuditDetailCollection _x = new AuditDetailCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.auditDetails = auditDetails;
        _x.moreRecords = moreRecords;
        _x.pagingCookie = pagingCookie;
        _x.totalRecordCount = totalRecordCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditDetailCollection[");
        b.append("AuditDetails=");
        b.append(this.auditDetails);
        b.append(", ");
        b.append("MoreRecords=");
        b.append(this.moreRecords);
        b.append(", ");
        b.append("PagingCookie=");
        b.append(this.pagingCookie);
        b.append(", ");
        b.append("TotalRecordCount=");
        b.append(this.totalRecordCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
