/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.EntityAndAttribute;
import microsoft.dynamics.crm.complex.LookupEntityInfo;

@JsonPropertyOrder(value={"@odata.type", "LookupEntityByName", "EntityAndAttribute", "AppId", "RelatedRecordId", "QueryString", "ReturnMetadata"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LookupDataRequest
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="LookupEntityByName")
    protected List<LookupEntityInfo> lookupEntityByName;
    @JsonProperty(value="LookupEntityByName@nextLink")
    protected String lookupEntityByNameNextLink;
    @JsonProperty(value="EntityAndAttribute")
    protected EntityAndAttribute entityAndAttribute;
    @JsonProperty(value="AppId")
    protected String appId;
    @JsonProperty(value="RelatedRecordId")
    protected String relatedRecordId;
    @JsonProperty(value="QueryString")
    protected String queryString;
    @JsonProperty(value="ReturnMetadata")
    protected Boolean returnMetadata;

    protected LookupDataRequest() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupDataRequest";
    }

    @Property(name="LookupEntityByName")
    @JsonIgnore
    public CollectionPage<LookupEntityInfo> getLookupEntityByName() {
        return new CollectionPage(this.contextPath, LookupEntityInfo.class, this.lookupEntityByName, Optional.ofNullable(this.lookupEntityByNameNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="LookupEntityByName")
    @JsonIgnore
    public CollectionPage<LookupEntityInfo> getLookupEntityByName(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, LookupEntityInfo.class, this.lookupEntityByName, Optional.ofNullable(this.lookupEntityByNameNextLink), Collections.emptyList(), options);
    }

    @Property(name="EntityAndAttribute")
    @JsonIgnore
    public Optional<EntityAndAttribute> getEntityAndAttribute() {
        return Optional.ofNullable(this.entityAndAttribute);
    }

    public LookupDataRequest withEntityAndAttribute(EntityAndAttribute entityAndAttribute) {
        LookupDataRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.entityAndAttribute = entityAndAttribute;
        return _x;
    }

    @Property(name="AppId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(this.appId);
    }

    public LookupDataRequest withAppId(String appId) {
        LookupDataRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.appId = appId;
        return _x;
    }

    @Property(name="RelatedRecordId")
    @JsonIgnore
    public Optional<String> getRelatedRecordId() {
        return Optional.ofNullable(this.relatedRecordId);
    }

    public LookupDataRequest withRelatedRecordId(String relatedRecordId) {
        LookupDataRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.relatedRecordId = relatedRecordId;
        return _x;
    }

    @Property(name="QueryString")
    @JsonIgnore
    public Optional<String> getQueryString() {
        return Optional.ofNullable(this.queryString);
    }

    public LookupDataRequest withQueryString(String queryString) {
        Checks.checkIsAscii((String)queryString);
        LookupDataRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.queryString = queryString;
        return _x;
    }

    @Property(name="ReturnMetadata")
    @JsonIgnore
    public Optional<Boolean> getReturnMetadata() {
        return Optional.ofNullable(this.returnMetadata);
    }

    public LookupDataRequest withReturnMetadata(Boolean returnMetadata) {
        LookupDataRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.returnMetadata = returnMetadata;
        return _x;
    }

    public LookupDataRequest withUnmappedField(String name, String value) {
        LookupDataRequest _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private LookupDataRequest _copy() {
        LookupDataRequest _x = new LookupDataRequest();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.lookupEntityByName = this.lookupEntityByName;
        _x.entityAndAttribute = this.entityAndAttribute;
        _x.appId = this.appId;
        _x.relatedRecordId = this.relatedRecordId;
        _x.queryString = this.queryString;
        _x.returnMetadata = this.returnMetadata;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupDataRequest[");
        b.append("LookupEntityByName=");
        b.append(this.lookupEntityByName);
        b.append(", ");
        b.append("EntityAndAttribute=");
        b.append(this.entityAndAttribute);
        b.append(", ");
        b.append("AppId=");
        b.append(this.appId);
        b.append(", ");
        b.append("RelatedRecordId=");
        b.append(this.relatedRecordId);
        b.append(", ");
        b.append("QueryString=");
        b.append(this.queryString);
        b.append(", ");
        b.append("ReturnMetadata=");
        b.append(this.returnMetadata);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<LookupEntityInfo> lookupEntityByName;
        private String lookupEntityByNameNextLink;
        private EntityAndAttribute entityAndAttribute;
        private String appId;
        private String relatedRecordId;
        private String queryString;
        private Boolean returnMetadata;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder lookupEntityByName(List<LookupEntityInfo> lookupEntityByName) {
            this.lookupEntityByName = lookupEntityByName;
            this.changedFields = this.changedFields.add("LookupEntityByName");
            return this;
        }

        public Builder lookupEntityByName(LookupEntityInfo ... lookupEntityByName) {
            return this.lookupEntityByName(Arrays.asList(lookupEntityByName));
        }

        public Builder lookupEntityByNameNextLink(String lookupEntityByNameNextLink) {
            this.lookupEntityByNameNextLink = lookupEntityByNameNextLink;
            this.changedFields = this.changedFields.add("LookupEntityByName");
            return this;
        }

        public Builder entityAndAttribute(EntityAndAttribute entityAndAttribute) {
            this.entityAndAttribute = entityAndAttribute;
            this.changedFields = this.changedFields.add("EntityAndAttribute");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = this.changedFields.add("AppId");
            return this;
        }

        public Builder relatedRecordId(String relatedRecordId) {
            this.relatedRecordId = relatedRecordId;
            this.changedFields = this.changedFields.add("RelatedRecordId");
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            this.changedFields = this.changedFields.add("QueryString");
            return this;
        }

        public Builder returnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
            this.changedFields = this.changedFields.add("ReturnMetadata");
            return this;
        }

        public LookupDataRequest build() {
            LookupDataRequest _x = new LookupDataRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupDataRequest";
            _x.lookupEntityByName = this.lookupEntityByName;
            _x.lookupEntityByNameNextLink = this.lookupEntityByNameNextLink;
            _x.entityAndAttribute = this.entityAndAttribute;
            _x.appId = this.appId;
            _x.relatedRecordId = this.relatedRecordId;
            _x.queryString = this.queryString;
            _x.returnMetadata = this.returnMetadata;
            return _x;
        }
    }
}

