package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TimeCode implements Enum {

    @JsonProperty("Available")
    AVAILABLE("Available", "0"),

    @JsonProperty("Busy")
    BUSY("Busy", "1"),

    @JsonProperty("Unavailable")
    UNAVAILABLE("Unavailable", "2"),

    @JsonProperty("Filter")
    FILTER("Filter", "3");

    private final String name;
    private final String value;

    private TimeCode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
