package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RelationshipType implements Enum {

    @JsonProperty("OneToManyRelationship")
    ONE_TO_MANY_RELATIONSHIP("OneToManyRelationship", "0"),

    @JsonProperty("ManyToManyRelationship")
    MANY_TO_MANY_RELATIONSHIP("ManyToManyRelationship", "1");

    private final String name;
    private final String value;

    private RelationshipType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
