package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrivilegeDepth implements Enum {

    @JsonProperty("Basic")
    BASIC("Basic", "0"),

    @JsonProperty("Local")
    LOCAL("Local", "1"),

    @JsonProperty("Deep")
    DEEP("Deep", "2"),

    @JsonProperty("Global")
    GLOBAL("Global", "3");

    private final String name;
    private final String value;

    private PrivilegeDepth(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
