package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OrderType implements Enum {

    @JsonProperty("Ascending")
    ASCENDING("Ascending", "0"),

    @JsonProperty("Descending")
    DESCENDING("Descending", "1");

    private final String name;
    private final String value;

    private OrderType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
